/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui.border;

import com.amazon.kindle.kindlet.ui.border.KAbstractBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class KLineBorder
extends KAbstractBorder {
    private static final long a = -45434541L;
    protected int m_thickness;
    protected int m_arcWidth;
    protected int m_arcHeight;
    protected Color m_fgColor;
    protected Color m_bgColor;
    protected boolean m_roundedCorners;

    public KLineBorder() {
        this(1, true);
    }

    public KLineBorder(int thickness) {
        this(thickness, true);
    }

    public KLineBorder(int thickness, boolean roundedCorners) {
        this.setForegroundColor(Color.BLACK);
        this.setBackgroundColor(Color.WHITE);
        this.m_thickness = thickness;
        this.m_roundedCorners = roundedCorners;
        this.setArcWidth(thickness);
        this.setArcHeight(thickness);
    }

    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Color a2 = g2.getColor();
        g2.setColor(this.getForegroundColor());
        if (this.m_roundedCorners) {
            g2.fillRoundRect(x2, y2, width, height, this.m_arcWidth, this.m_arcHeight);
            g2.setColor(this.getBackgroundColor());
            g2.fillRoundRect(x2 + this.m_thickness, y2 + this.m_thickness, width - 2 * this.m_thickness, height - 2 * this.m_thickness, this.m_arcWidth - 2 * this.m_thickness, this.m_arcHeight - 2 * this.m_thickness);
        } else {
            g2.fillRect(x2, y2, width, height);
            g2.setColor(this.getBackgroundColor());
            g2.fillRect(x2 + this.m_thickness, y2 + this.m_thickness, width - 2 * this.m_thickness, height - 2 * this.m_thickness);
        }
        g2.setColor(a2);
    }

    public Insets getBorderInsets(Component c2) {
        return new Insets(this.m_thickness, this.m_thickness, this.m_thickness, this.m_thickness);
    }

    public Insets getBorderInsets(Component c2, Insets insets) {
        insets.right = insets.bottom = this.m_thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getForegroundColor() {
        return this.m_fgColor;
    }

    public Color getBackgroundColor() {
        return this.m_bgColor;
    }

    public void setForegroundColor(Color color) {
        if (color != null) {
            this.m_fgColor = color;
        }
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.m_bgColor = color;
        }
    }

    public int getThickness() {
        return this.m_thickness;
    }

    public boolean hasRoundedCorners() {
        return this.m_roundedCorners;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public int getArcWidth() {
        return this.m_arcWidth;
    }

    public int getArcHeight() {
        return this.m_arcHeight;
    }

    public void setArcWidth(int width) {
        this.m_arcWidth = this.m_roundedCorners ? width : 0;
    }

    public void setArcHeight(int height) {
        this.m_arcHeight = this.m_roundedCorners ? height : 0;
    }
}

