/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui;

import com.amazon.kindle.kindlet.ui.Focus2DTraversable;
import com.amazon.kindle.kindlet.ui.Focus2DTraversalPolicy;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class KComponent
extends Container
implements Focus2DTraversable {
    static final int FOCUS_2D_TRAVERSAL_KEY_LENGTH = 2;
    private final Set[] focus2DTraversalKeys = new Set[2];
    private static final String[] focus2DTraversalKeyPropertyNames = new String[]{"aboveFocusTraversalKeys", "belowFocusTraversalKeys"};
    private volatile Point m_entryPoint;
    private volatile Rectangle m_entryBounds;

    public KComponent() {
        super.setForeground(Color.BLACK);
        super.setBackground(Color.WHITE);
        this.m_entryPoint = null;
    }

    public void transferFocusAbove() {
        FocusTraversalPolicy a2;
        Container a3 = this.a().getFocusCycleRootAncestor();
        if (a3 != null && (a2 = a3.getFocusTraversalPolicy()) instanceof Focus2DTraversalPolicy) {
            Focus2DTraversalPolicy a4 = (Focus2DTraversalPolicy)a2;
            Component a5 = a4.getComponentAbove(a3, this);
            if (a5 == null) {
                a5 = a4.getDefaultComponent(a3);
            }
            if (a5 != null) {
                a5.requestFocus();
            }
        }
    }

    public void transferFocusBelow() {
        FocusTraversalPolicy a2;
        Container a3 = this.a().getFocusCycleRootAncestor();
        if (a3 != null && (a2 = a3.getFocusTraversalPolicy()) instanceof Focus2DTraversalPolicy) {
            Focus2DTraversalPolicy a4 = (Focus2DTraversalPolicy)a2;
            Component a5 = a4.getComponentBelow(a3, this);
            if (a5 == null) {
                a5 = a4.getDefaultComponent(a3);
            }
            if (a5 != null) {
                a5.requestFocus();
            }
        }
    }

    public void setEntryPoint(Point inEntryPoint) {
        this.m_entryPoint = inEntryPoint;
        this.m_entryBounds = this.getBounds();
    }

    public Point getEntryPoint() {
        if (null == this.m_entryPoint) {
            return null;
        }
        return (Point)this.m_entryPoint.clone();
    }

    public void setBounds(int x2, int y2, int width, int height) {
        Point a2 = this.getEntryPoint();
        if (a2 != null) {
            int a3 = this.m_entryBounds.x + this.m_entryPoint.x;
            int a4 = this.m_entryBounds.y + this.m_entryPoint.y;
            if (a3 < x2) {
                a3 = x2;
            } else if (a3 >= x2 + width) {
                a3 = x2 + width - 1;
            }
            if (a4 < y2) {
                a4 = y2;
            } else if (a4 > y2 + height) {
                a4 = y2 + height - 1;
            }
            a2.x = a3 - x2;
            a2.y = a4 - y2;
            this.setEntryPoint(a2);
        }
        super.setBounds(x2, y2, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocus2DTraversalKeys(int id, Set keystrokes) {
        KComponent kComponent = this;
        synchronized (kComponent) {
            this.a(this.focus2DTraversalKeys, id, keystrokes);
        }
    }

    public Set getFocus2DTraversalKeys(int id) {
        if (id < 0 || id >= 2) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        Set a2 = this.focus2DTraversalKeys[id];
        if (a2 != null) {
            return a2;
        }
        Container a3 = this.getParent();
        if (a3 instanceof Focus2DTraversable) {
            return ((Focus2DTraversable)((Object)a3)).getFocus2DTraversalKeys(id);
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areFocus2DTraversalKeysSet(int id) {
        if (id < 0 || id >= 2) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        KComponent kComponent = this;
        synchronized (kComponent) {
            return this.focus2DTraversalKeys[id] != null;
        }
    }

    private void a(Set[] a2, int a3, Set a4) {
        KComponent a5;
        Iterator a6;
        if (a3 < 0 || a3 >= 2) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        if (a4 == null) {
            a2[a3] = null;
            return;
        }
        Set a7 = null;
        Iterator iterator = a6 = a4.iterator();
        while (iterator.hasNext()) {
            int a8;
            Object a9 = a6.next();
            if (!(a9 instanceof AWTKeyStroke)) {
                throw new IllegalArgumentException("focus traversal keys must be non-null AWTKeyStrokes");
            }
            AWTKeyStroke a10 = (AWTKeyStroke)a9;
            if (a10.getKeyEventType() == 400) {
                throw new IllegalArgumentException("KEY_TYPED events are not permitted for focus traversal");
            }
            int n2 = a8 = a3 == 0 ? 1 : 0;
            if (a2[a8] != null && a2[a8].contains(a10)) {
                throw new IllegalArgumentException("focus traversal keys must be unique for a Component");
            }
            a7 = a2[a3];
            a2[a3] = Collections.unmodifiableSet(new HashSet(a4));
            iterator = a6;
        }
        a5.firePropertyChange(focus2DTraversalKeyPropertyNames[a3], a7, a4);
    }

    private Component a() {
        KComponent a2;
        Container a3 = a2.getFocusCycleRootAncestor();
        Container a4 = a2;
        Container container = a3;
        while (!(container == null || a3.isShowing() && a3.isFocusable() && a3.isEnabled())) {
            a4 = a3;
            container = a3.getFocusCycleRootAncestor();
        }
        return a4;
    }

    protected boolean isChange(Object currentObject, Object newObject) {
        return (currentObject == null || newObject == null) && newObject != currentObject || currentObject != null && newObject != null && !currentObject.equals(newObject);
    }

    public boolean imageUpdate(Image image, int flags, int x2, int y2, int w2, int h2) {
        if ((flags & 0x30) != 0) {
            this.repaint(0L, 0, 0, this.getWidth(), this.getHeight());
        }
        return (flags & 0xA0) == 0;
    }
}

