/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.media;

import com.amazon.kindle.kindlet.media.AudioException;
import com.amazon.kindle.kindlet.media.AudioListener;
import com.amazon.kindle.kindlet.media.AudioState;
import com.amazon.kindle.kindlet.media.AudioStateChange;

public interface Audio {
    public static final int AUDIO_LOOP_INFINITE = -1;
    public static final AudioState CREATE = new AudioState("Created");
    public static final AudioState READY = new AudioState("Ready");
    public static final AudioState PLAYING = new AudioState("Playing");
    public static final AudioStateChange END_OF_STREAM = new AudioStateChange(PLAYING, CREATE);
    public static final AudioState END = new AudioState("Released");
    public static final AudioState ERROR = new AudioState("Error");
    public static final AudioStateChange PREFETCHED = new AudioStateChange(CREATE, READY);
    public static final AudioStateChange STARTED = new AudioStateChange(READY, PLAYING);
    public static final AudioStateChange PAUSED = new AudioStateChange(PLAYING, READY);

    public void release();

    public void prefetch() throws IllegalStateException;

    public void play() throws IllegalStateException;

    public void pause() throws IllegalStateException;

    public void seek(int var1) throws IllegalStateException, UnsupportedOperationException;

    public void setLoopCount(int var1) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException;

    public AudioState getState();

    public int getCurrentPosition() throws AudioException, IllegalStateException, UnsupportedOperationException;

    public int getDuration() throws AudioException, IllegalStateException, UnsupportedOperationException;

    public boolean isPlaying();

    public void addAudioListener(AudioListener var1);

    public void removeAudioListener(AudioListener var1);

    public void removeAllAudioListeners();
}

