/*
 * Decompiled with CFR 0.152.
 */
package WT.Kindle.ClippingsLibrary;

import WT.Kindle.ClippingsLibrary.Utility;
import java.io.Serializable;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clipping
implements Serializable,
Comparable<Clipping> {
    private static final long serialVersionUID = -1988453502727750868L;
    private String author;
    private String title;
    private int[] startEnd;
    private int page;
    private String type;
    private Calendar date;
    private String text;

    public Clipping() {
        this.author = null;
        this.title = null;
        this.startEnd = null;
        this.type = null;
        this.date = Calendar.getInstance();
        this.text = null;
        this.page = 0;
    }

    public Clipping(String input) {
        this.author = Clipping.parseAuthor(input);
        this.title = Clipping.parseTitle(input);
        this.startEnd = Clipping.parseStartEnd(input);
        this.type = Clipping.parseType(input);
        this.date = Calendar.getInstance();
        this.date = Clipping.parseDateTime(input);
        this.text = Clipping.parseText(input);
        this.page = Clipping.parsePage(input);
    }

    private static String parseAuthor(String input) {
        String temp = input.substring(0, input.indexOf("\n"));
        Utility.debug("Clipping", "parseAuthor", "temp", temp);
        Integer authorStartIndex = temp.lastIndexOf("(");
        Utility.debug("Clipping", "parseAuthor", "authorStartIndex", authorStartIndex.toString());
        authorStartIndex = authorStartIndex + 1;
        Utility.debug("Clipping", "parseAuthor", "authorStartIndex", authorStartIndex.toString());
        Integer authorEndIndex = temp.lastIndexOf(")");
        Utility.debug("Clipping", "parseAuthor", "authorEndIndex", authorEndIndex.toString());
        String author = new String(temp.substring(authorStartIndex, authorEndIndex));
        author = author.trim();
        return author;
    }

    private static String parseTitle(String input) {
        String temp = new String(input.substring(0, input.indexOf("\n")));
        int authorStartIndex = temp.lastIndexOf("(");
        String title = new String(temp.substring(0, authorStartIndex));
        title = title.trim();
        return title;
    }

    private static int[] parseStartEnd(String input) {
        Utility.debug("Clipping", "parseStartEnd", "input", input);
        int[] retVal = new int[2];
        String startEnd = new String(input.substring(input.indexOf("\n") + 3, input.lastIndexOf(" | ")));
        Utility.debug("Clipping", "parseStartEnd", "startEnd", startEnd);
        startEnd = startEnd.contains("Loc.") ? new String(startEnd.substring(startEnd.indexOf("Loc.") + 5)) : "0";
        Utility.debug("Clipping", "parseStartEnd", "startEnd", startEnd);
        startEnd = startEnd.trim();
        if (startEnd.contains("-")) {
            String[] temp = startEnd.split("-");
            temp[0] = temp[0].trim();
            temp[1] = temp[1].trim();
            retVal[0] = Integer.parseInt(temp[0]);
            retVal[1] = Integer.parseInt(temp[1]);
        } else {
            retVal[0] = retVal[1] = Integer.parseInt(startEnd);
        }
        return retVal;
    }

    private static int parsePage(String input) {
        Utility.debug("Clipping", "parseStartEnd", "input", input);
        int retVal = 0;
        String startEnd = new String(input.substring(input.indexOf("\n") + 3, input.indexOf(" | ")));
        Utility.debug("Clipping", "parsePage", "startEnd", startEnd);
        startEnd = startEnd.contains("Loc.") ? "0" : new String(startEnd.substring(startEnd.indexOf("Page") + 5));
        Utility.debug("Clipping", "parsePage", "startEnd", startEnd);
        startEnd = startEnd.trim();
        retVal = Integer.parseInt(startEnd);
        return retVal;
    }

    private static String parseType(String input) {
        String type = new String(input.substring(input.indexOf("\n") + 3, input.lastIndexOf(" | ")));
        if (type.contains("Loc.")) {
            type = new String(type.substring(0, type.indexOf(" Loc. ")));
        }
        if (type.contains("Page") && (type = new String(type.substring(0, type.indexOf("Page")))).contains("on")) {
            type = type.replace("on", "");
        }
        type = type.trim();
        return type;
    }

    private static Calendar parseDateTime(String input) {
        String date = new String(input.substring(input.indexOf("|")));
        if (date.contains("\n")) {
            date = date.substring(0, date.indexOf("\n"));
        }
        date = date.replace("| Added on ", "");
        Calendar calendar = Calendar.getInstance();
        String strMonth = new String(date.substring(date.indexOf(", ")));
        date = new String(strMonth.substring(strMonth.indexOf(" ")));
        strMonth = strMonth.replace(", ", "#");
        date = new String(strMonth.substring(strMonth.indexOf(" ")));
        strMonth = new String(strMonth.substring(0, strMonth.indexOf(" ")));
        strMonth = new String(strMonth.substring(1));
        String[] dayYearTime = date.split("#");
        dayYearTime[0] = dayYearTime[0].trim();
        dayYearTime[1] = dayYearTime[1].trim();
        dayYearTime[2] = dayYearTime[2].trim();
        int month = Utility.monthToInt(strMonth);
        int day = Integer.parseInt(dayYearTime[0]);
        int year = Integer.parseInt(dayYearTime[1]);
        int[] time = Utility.timeToInt(dayYearTime[2]);
        calendar.set(year, --month, day, time[0], time[1]);
        return calendar;
    }

    private static String parseText(String input) {
        input = String.valueOf(input) + "\n";
        Utility.debug("Clipping", "parseText", "input", input);
        String text = "";
        Utility.debug("Clipping", "parseText", "input.lastIndexOf(\"\\n\")", Integer.toString(input.lastIndexOf("\n")));
        Utility.debug("Clipping", "parseText", "input.length()", Integer.toString(input.length()));
        text = new String(input.substring(input.indexOf("\n", input.indexOf("\n") + 1)));
        text = text.trim();
        Utility.debug("Clipping", "parseText", "text", text);
        return text;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public int[] getStartEnd() {
        return this.startEnd;
    }

    public String getType() {
        return this.type;
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getText() {
        return this.text;
    }

    public int getPage() {
        return this.page;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStartEnd(int[] startEnd) {
        this.startEnd = startEnd;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String toXML(int indentation) {
        String indent = "";
        int i = 0;
        while (i < indentation) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        String xml = "";
        xml = String.valueOf(xml) + "\n" + indent + "<" + this.type + ">";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Start>" + this.startEnd[0] + "</Start>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<End>" + this.startEnd[1] + "</End>";
        if (this.page > 0) {
            xml = String.valueOf(xml) + "\n\t" + indent + "<Page>" + this.page + "</Page>";
        }
        if (this.startEnd[0] > 0 && this.startEnd[1] > 0) {
            xml = String.valueOf(xml) + "\n\t" + indent + "<Date>" + Utility.calendarToDateString(this.date) + "</Date>";
            xml = String.valueOf(xml) + "\n\t" + indent + "<Time>" + Utility.calendarToTimeString(this.date) + "</Time>";
        }
        xml = String.valueOf(xml) + "\n\t" + indent + "<Text>" + this.text + "</Text>";
        xml = String.valueOf(xml) + "\n" + indent + "</" + this.type + ">";
        return xml;
    }

    public String toString() {
        String retval = "Clipping[" + this.title + ", " + this.author + ", " + this.startEnd[0] + ", " + this.startEnd[1] + ", " + this.page + ", " + this.type + ", " + this.date.toString() + ", " + this.text + "]";
        return retval;
    }

    public boolean equals(Clipping o) {
        boolean page;
        boolean text = this.getText().equals(o.getText());
        boolean type = this.getType().equals(o.getType());
        boolean start = this.getStartEnd()[0] == o.getStartEnd()[0];
        boolean end = this.getStartEnd()[1] == o.getStartEnd()[1];
        boolean author = this.getAuthor().equals(o.getAuthor());
        boolean title = this.getTitle().equals(o.getTitle());
        boolean bl = page = this.getPage() == o.getPage();
        return text && type && start && end && author && title && page;
    }

    @Override
    public int compareTo(Clipping o) {
        Utility.debug("Clipping", "compareTo", "This start", Integer.toString(this.getStartEnd()[0]));
        Utility.debug("Clipping", "compareTo", "This end", Integer.toString(this.getStartEnd()[1]));
        Utility.debug("Clipping", "compareTo", "o start", Integer.toString(o.getStartEnd()[0]));
        Utility.debug("Clipping", "compareTo", "o end", Integer.toString(o.getStartEnd()[1]));
        if (this.getStartEnd()[0] == o.getStartEnd()[0] && this.getStartEnd()[1] == o.getStartEnd()[1]) {
            Utility.debug("Clipping", "compareTo", "Equal");
            return 0;
        }
        Utility.debug("Clipping", "compareTo", "Not Equal");
        if (this.getStartEnd()[0] > o.getStartEnd()[0]) {
            Utility.debug("Clipping", "compareTo", "After");
            return 1;
        }
        Utility.debug("Clipping", "compareTo", "Before");
        return -1;
    }
}

