/*
 * Decompiled with CFR 0.152.
 */
package WT.Kindle.ClippingsLibrary;

import WT.Kindle.ClippingsLibrary.Clipping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Book
implements Serializable {
    private static final long serialVersionUID = -6397251863982533938L;
    private String title;
    private String author;
    private ArrayList<Clipping> clippings;
    private boolean isTitleSet;
    private boolean isAuthorSet;

    public Book() {
        this.title = "";
        this.author = "";
        this.clippings = new ArrayList();
        this.isTitleSet = false;
        this.isAuthorSet = false;
    }

    public Book(String title) {
        this.title = title;
        this.author = "";
        this.clippings = new ArrayList();
        this.isTitleSet = true;
        this.isAuthorSet = false;
    }

    public Book(String title, String author) {
        this.title = title;
        this.author = author;
        this.clippings = new ArrayList();
        this.isTitleSet = true;
        this.isAuthorSet = true;
    }

    public boolean IsTitleSet() {
        return this.isTitleSet;
    }

    public boolean IsAuthorSet() {
        return this.isAuthorSet;
    }

    public boolean isClippingInBook(Clipping clipping) {
        boolean retval = false;
        for (Clipping clip : this.clippings) {
            if (!clip.equals(clipping)) continue;
            retval = true;
        }
        return retval;
    }

    public void add(Clipping clipping) {
        this.add(clipping, false);
    }

    public void add(Clipping clipping, boolean checkExists) {
        if (this.title.equals(clipping.getTitle()) && this.author.equals(clipping.getAuthor())) {
            if (checkExists) {
                if (!this.isClippingInBook(clipping)) {
                    this.clippings.add(clipping);
                }
            } else {
                this.clippings.add(clipping);
            }
        }
    }

    public void add(ArrayList<Clipping> clippings) {
        for (Clipping clipping : clippings) {
            this.add(clipping);
        }
    }

    public void setTitle(String title) {
        if (!this.isTitleSet) {
            this.title = title;
            this.isTitleSet = true;
        }
    }

    public void setAuthor(String author) {
        if (!this.isTitleSet) {
            this.author = author;
            this.isAuthorSet = true;
        }
    }

    public void setClippings(ArrayList<Clipping> clippings) {
        this.clippings = clippings;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public ArrayList<Clipping> getClippings() {
        return this.clippings;
    }

    public String toXML(int indentation) {
        String indent = "";
        int i = 0;
        while (i < indentation) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        String xml = "";
        xml = String.valueOf(xml) + "\n" + indent + "<Book>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Title>" + this.title + "</Title>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Author>" + this.author + "</Author>";
        for (Clipping clipping : this.clippings) {
            xml = String.valueOf(xml) + clipping.toXML(indentation + 1);
        }
        xml = String.valueOf(xml) + "\n" + indent + "</Book>";
        return xml;
    }

    public String toString() {
        String retVal = String.valueOf(this.title) + "(" + this.clippings.size() + ")";
        return retVal;
    }

    public void sortClippings() {
        Collections.sort(this.clippings);
    }
}

