#!/usr/bin/python
#eMonitor by Kranu

#BEGIN SETUP

#HTTP Server
port=8000              #port of http server (http://127.0.0.1:8000/)

#capture region
l,t=(0,0)    #left and right offset from primary monitor
w,h=(600,706)          #width and height of capture region
fn ='shot.png'         #file name of screenshot

#//END SETUP

import wx
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer

class serv(BaseHTTPRequestHandler):
  def do_GET(self):
    self.send_response(200)
    if self.path.startswith('/shot.png'):
      self.send_header('Content-type','image/png')
      self.end_headers()
  
      app=wx.PySimpleApp()
      context=wx.ScreenDC()
      bitmap=wx.EmptyBitmap(w, h, -1)
 
      memory=wx.MemoryDC()
      memory.SelectObject(bitmap)
      memory.Blit(0, 0, w, h, context, l, t)
      memory.SelectObject(wx.NullBitmap)
 
      bitmap.SaveFile(fn, wx.BITMAP_TYPE_PNG)

      f=open(fn,'rb')
      self.wfile.write(f.read())
    else:
      self.send_header('Content-type','text/html')
      self.end_headers()
      self.wfile.write('<!doctype html>'\
        '<html lang="en">'\
        '<head>'\
        '<title>eMonitor by Kranu</title>'\
        '</head>'\
        '<body style="margin:0px;">'\
        '<img id="pic" src="'+fn+'" style="width:100%;height:100%;">'\
        '<script type="text/javascript">'\
        'document.getElementById("pic").onload=function() {'\
        '  document.getElementById("pic").src="'+fn+'?"+(new Date()).getTime();'\
        '}'\
        '</script>'\
        '</body>'\
        '</html>')
try:
  print 'Starting.. press Ctrl+C to stop'
  server=HTTPServer(('',port),serv)
  server.serve_forever()
except KeyboardInterrupt:
  print 'Stopping.. ',
  server.socket.close()
  print 'Have a nice day!'