#!/usr/bin/python
#eMonitor by Kranu
#Version 2 (9-1-2011)

#Tested on Windows 7 x64, Python 2.7.2, wxPython 2.8
#For more information, see: http://goo.gl/rJoLp

#BEGIN SETUP

#HTTP Server
port=8000              #port of http server (http://127.0.0.1:8000/)

#capture region
#l,t=(1680,1050-800)
l,t=(0,0)              #left and right offset from primary monitor
w,h=(595,701)          #width and height of capture region
fn ='shot.jpg'         #file name of screenshot

#//END SETUP

import wx,socket
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer

class serv(BaseHTTPRequestHandler):
  def do_GET(self):
    self.send_response(200)
    if self.path.startswith('/'+fn):
      self.send_header('Content-type','image/jpeg')
      self.end_headers()
  
      app=wx.PySimpleApp()
      context=wx.ScreenDC()
      bitmap=wx.EmptyBitmap(w, h, -1)
 
      memory=wx.MemoryDC()
      memory.SelectObject(bitmap)
      memory.Blit(0, 0, w, h, context, l, t)
      memory.SelectObject(wx.NullBitmap)
 
      image=wx.ImageFromBitmap(bitmap)
      data=list(image.GetData())
      
      for i in xrange(0,len(data),3):
        data[i]=data[i+1]=data[i+2]=chr(int(0.2989*float(ord(data[i]))+0.5870*float(ord(data[i+1]))+0.1140*float(ord(data[i+2]))))
      
      #stream=wx.MemoryOutputStream()
      #buffer=stream.GetOutputStreamBuffer()

      image.SetData("".join(data))
      image.SaveFile(fn,wx.BITMAP_TYPE_JPEG)

      f=open(fn,'rb')
      self.wfile.write(f.read())
    else:
      self.send_header('Content-type','text/html')
      self.end_headers()
      self.wfile.write('<!doctype html>'\
        '<html lang="en">'\
        '<head>'\
        '<title>eMonitor by Kranu</title>'\
        '</head>'\
        '<body style="margin:0px;">'\
        '<img id="pic" src="'+fn+'" style="float:left;width:100%;height:100%;">'\
        '<script type="text/javascript">'\
        'document.getElementById("pic").onload=function() {'\
        '  document.getElementById("pic").src="'+fn+'?"+(new Date()).getTime();'\
        '}'\
        '</script>'\
        '</body>'\
        '</html>')
try:
  print 'eMonitor by Kranu'

  #Amazon's website is used here for its reliablity. Feel free to change it.
  s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
  s.connect(("amazon.com",80))

  print 'Starting.. ',
  server=HTTPServer(('',port),serv)
  print 'Press Ctrl+C to stop'
  print

  print 'On your Kindle, visit http://'+s.getsockname()[0]+':'+str(port)+'/'

  server.serve_forever()
except KeyboardInterrupt:
  print 'Stopping.. ',
  server.socket.close()
  print 'Have a nice day!'