#!/bin/sh

# Kindle 3.2.1 Jailbreak Generator
# Copyright (C) 2011  Yifan Lu
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

VERSION="0.5.1"
#MAX_PID=32768
UPDATE_TOOL="kindle_update_tool.py"
INSTALLER="install.sh"
UNINSTALLER="uninstall.sh"
PAYLOAD_DIR="./payload"
OUTPUT="./bin"
TEMP="./tmp.$$"
DAT_FILE="update\dat"
DAT_FAKE="updatedat"

echo Cleaning up
find . -type f -name '.DS_Store' -or -type f -name '._*' -exec rm -f {} \;
rm -rf ${OUTPUT}
mkdir ${OUTPUT}

echo Creating temporary folder
mkdir ${TEMP}

echo Generating payload
tar -C ${PAYLOAD_DIR} -czvf ${TEMP}/payload.sig jailbreak pubprodkey01.hack.pem

echo Make sure executable
chmod +x ${INSTALLER}
chmod +x ${UNINSTALLER}

echo Copying installer
cp -a ${INSTALLER} ${TEMP}/jailbreak.sig

echo Generating dat
ID=129
MD5=`md5sum ${INSTALLER} | awk '{print $1}'`
SIZE=`ls -l ${INSTALLER} | awk '{print $5}'`
FILENAME="jailbreak.sig"
BLOCKS=`expr ${SIZE} / 64`
NAME="jailbreak"

echo "${ID} ${MD5} ${FILENAME} ${BLOCKS} ${NAME}" > "${TEMP}/${DAT_FILE}"

echo Generating exploit

cp -a hook.dat "${TEMP}/${DAT_FAKE}"
cp -a hook.sig "${TEMP}/${DAT_FAKE}.sig"

echo Packaging jailbreak
cd ${TEMP}
tar cvf ../bin/jailbreak.tar *
gzip ../bin/jailbreak.tar
cd ..
cd ${OUTPUT}
KINDLE_MODELS="k2 k2i dx dxi dxg k3g k3w k3gb"
for model in ${KINDLE_MODELS}; do
	python ../${UPDATE_TOOL} c --${model} jailbreak_${VERSION}_${model}_install jailbreak.tar.gz
done
rm -f jailbreak.tar.gz
cd ..
echo Generating uninstaller
for model in ${KINDLE_MODELS}; do
	python ${UPDATE_TOOL} m --${model} --sign jailbreak_${VERSION}_${model}_uninstall ${UNINSTALLER}
	mv update_jailbreak_${VERSION}_${model}_uninstall.bin ${OUTPUT}
done

echo Cleaning up
rm -rf ${TEMP}
