/*
 * Decompiled with CFR 0.152.
 */
package WT.Kindle.Clippings;

import WT.Kindle.Clippings.Book;
import WT.Kindle.Clippings.Clipping;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utility {
    private static boolean debugON = false;

    public static String calendarToDateString(Calendar cal) {
        int intDay = cal.get(5);
        int intMonth = cal.get(2);
        int intYear = cal.get(1);
        String strDay = intDay < 10 ? "0" + intDay : "" + intDay;
        String strMonth = intMonth < 10 ? "0" + intMonth : "" + ++intMonth;
        String retVal = String.valueOf(strDay) + "/" + strMonth + "/" + intYear;
        return retVal;
    }

    public static String calendarToTimeString(Calendar cal) {
        int intHour = cal.get(11);
        int intMin = cal.get(12);
        String strHour = intHour < 10 ? "0" + intHour : "" + intHour;
        String strMin = intMin < 10 ? "0" + intMin : "" + intMin;
        String retVal = String.valueOf(strHour) + ":" + strMin;
        return retVal;
    }

    public static Clipping[] parseClippings(String input) {
        String[] clippings;
        ArrayList<Clipping> retVal = new ArrayList<Clipping>();
        String delimiter = "==========";
        input = input.substring(0, input.lastIndexOf(delimiter));
        String[] stringArray = clippings = input.split(delimiter);
        int n = clippings.length;
        int n2 = 0;
        while (n2 < n) {
            String clipping = stringArray[n2];
            Clipping clip = new Clipping(clipping.trim());
            retVal.add(clip);
            ++n2;
        }
        return retVal.toArray(new Clipping[0]);
    }

    public static ArrayList<Book> generateBooksList(String input) {
        Clipping[] clippings = Utility.parseClippings(input);
        ArrayList<Book> books = new ArrayList<Book>();
        Clipping[] clippingArray = clippings;
        int n = clippings.length;
        int n2 = 0;
        while (n2 < n) {
            Clipping clipping = clippingArray[n2];
            String clippingTitle = clipping.getTitle();
            boolean added = false;
            for (Book book : books) {
                if (!clippingTitle.equals(book.getTitle())) continue;
                book.getClippings().add(clipping);
                added = true;
            }
            if (!added) {
                Book book;
                book = new Book(clippingTitle);
                book.getClippings().add(clipping);
                books.add(book);
            }
            ++n2;
        }
        return books;
    }

    public static String generateBooksXML(String input) {
        String xml = Utility.generateBooksXML(Utility.generateBooksList(input));
        return xml;
    }

    public static String generateBooksXML(ArrayList<Book> input) {
        ArrayList<Book> books = input;
        String xml = "<Clippings>";
        for (Book book : books) {
            xml = String.valueOf(xml) + book.toXML(1);
        }
        xml = String.valueOf(xml) + "\n";
        xml = String.valueOf(xml) + "</Clippings>";
        return xml;
    }

    public static int monthToInt(String month) {
        int retVal = 0;
        if (month.equals("January")) {
            retVal = 1;
        } else if (month.equals("Febuary")) {
            retVal = 2;
        } else if (month.equals("March")) {
            retVal = 3;
        } else if (month.equals("April")) {
            retVal = 4;
        } else if (month.equals("May")) {
            retVal = 5;
        } else if (month.equals("June")) {
            retVal = 6;
        } else if (month.equals("July")) {
            retVal = 7;
        } else if (month.equals("August")) {
            retVal = 8;
        } else if (month.equals("September")) {
            retVal = 9;
        } else if (month.equals("October")) {
            retVal = 10;
        } else if (month.equals("November")) {
            retVal = 11;
        } else if (month.equals("December")) {
            retVal = 12;
        }
        Utility.debug("Utility", "monthToInt", "month", month);
        Utility.debug("Utility", "monthToInt", "month", month.replace("\r", "~").replace("\n", "#"));
        Utility.debug("Utility", "monthToInt", "retVal", Integer.toString(retVal));
        return retVal;
    }

    public static int[] timeToInt(String time) {
        int[] retVal = new int[2];
        String[] temp1 = time.split(":");
        String[] temp2 = temp1[1].split(" ");
        retVal[0] = Integer.parseInt(temp1[0]);
        retVal[1] = Integer.parseInt(temp2[0]);
        Utility.debug("Clipping", "timeToInt", "temp2[1]", "\"" + temp2[1] + "\"");
        if (time.contains("PM") && retVal[0] != 12) {
            retVal[0] = retVal[0] + 12;
        } else if (time.contains("AM") && retVal[0] == 12) {
            retVal[0] = 0;
        }
        return retVal;
    }

    public static void debug(String classs, String location, String variableName, String variable) {
        if (Utility.isDebugOn()) {
            System.out.println("Debug(" + classs + ":" + location + "): " + variableName + " = \"" + variable + "\"");
        }
    }

    public static void debug(String classs, String location, String message) {
        if (Utility.isDebugOn()) {
            System.out.println("Debug(" + classs + ":" + location + "): " + message);
        }
    }

    public static boolean isDebugOn() {
        return debugON;
    }

    public static void error(String classs, String location, String message) {
        System.out.println("An error has occured in class " + classs + ", method " + location + "!\nInformation:\n" + message);
    }

    public static String fileToString(String filePath) {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        try {
            FileInputStream f = new FileInputStream(filePath);
            f.read(buffer);
            f.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Utility.debug("Utility", "fileToString", "buffer", new String(buffer));
        return new String(buffer);
    }
}

