/*
 * Decompiled with CFR 0.152.
 */
package WT.Kindle.Clippings;

import WT.Kindle.Clippings.Utility;
import java.util.Calendar;

public class Clipping {
    private String author;
    private String title;
    private int[] startEnd;
    private String type;
    private Calendar date;
    private String text;

    public Clipping() {
        this.author = null;
        this.title = null;
        this.startEnd = null;
        this.type = null;
        this.date = Calendar.getInstance();
        this.text = null;
    }

    public Clipping(String input) {
        this.author = Clipping.parseAuthor(input);
        this.title = Clipping.parseTitle(input);
        this.startEnd = Clipping.parseStartEnd(input);
        this.type = Clipping.parseType(input);
        this.date = Calendar.getInstance();
        this.date = Clipping.parseDateTime(input);
        this.text = Clipping.parseText(input);
    }

    private static String parseAuthor(String input) {
        String temp = input.substring(0, input.indexOf("\n"));
        Integer authorStartIndex = temp.lastIndexOf("(");
        authorStartIndex = authorStartIndex + 1;
        Integer authorEndIndex = temp.lastIndexOf(")");
        String author = temp.substring(authorStartIndex, authorEndIndex);
        author = author.trim();
        return author;
    }

    private static String parseTitle(String input) {
        String temp = input.substring(0, input.indexOf("\n"));
        int authorStartIndex = temp.lastIndexOf("(");
        String title = temp.substring(0, authorStartIndex);
        title = title.trim();
        return title;
    }

    private static int[] parseStartEnd(String input) {
        int[] retVal = new int[2];
        String startEnd = input.substring(input.indexOf("Loc.") + 5, input.indexOf("|"));
        if ((startEnd = startEnd.trim()).contains("-")) {
            String[] temp = startEnd.split("-");
            temp[0] = temp[0].trim();
            temp[1] = temp[1].trim();
            retVal[0] = Integer.parseInt(temp[0]);
            retVal[1] = Integer.parseInt(temp[1]);
        } else {
            retVal[0] = retVal[1] = Integer.parseInt(startEnd);
        }
        return retVal;
    }

    private static String parseType(String input) {
        String type = input.substring(input.indexOf("\n") + 3, input.indexOf("Loc."));
        type = type.trim();
        return type;
    }

    private static Calendar parseDateTime(String input) {
        String date = input.substring(input.indexOf("|"));
        if (date.contains("\n")) {
            date = date.substring(0, date.indexOf("\n"));
        }
        date = date.replace("| Added on ", "");
        Calendar calendar = Calendar.getInstance();
        String strMonth = date.substring(date.indexOf(", "));
        date = strMonth.substring(strMonth.indexOf(" "));
        strMonth = strMonth.replace(", ", "#");
        date = strMonth.substring(strMonth.indexOf(" "));
        strMonth = strMonth.substring(0, strMonth.indexOf(" "));
        strMonth = strMonth.substring(1);
        String[] dayYearTime = date.split("#");
        dayYearTime[0] = dayYearTime[0].trim();
        dayYearTime[1] = dayYearTime[1].trim();
        dayYearTime[2] = dayYearTime[2].trim();
        int month = Utility.monthToInt(strMonth);
        int day = Integer.parseInt(dayYearTime[0]);
        int year = Integer.parseInt(dayYearTime[1]);
        int[] time = Utility.timeToInt(dayYearTime[2]);
        calendar.set(year, --month, day, time[0], time[1]);
        return calendar;
    }

    private static String parseText(String input) {
        String text = "";
        if (text.contains("\n")) {
            text = input.substring(input.indexOf("\n", input.indexOf("\n") + 1));
        }
        text = text.trim();
        return text;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public int[] getStartEnd() {
        return this.startEnd;
    }

    public String getType() {
        return this.type;
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getText() {
        return this.text;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStartEnd(int[] startEnd) {
        this.startEnd = startEnd;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toXML(int indentation) {
        String indent = "";
        int i = 0;
        while (i < indentation) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        String xml = "";
        xml = String.valueOf(xml) + "\n" + indent + "<" + this.type + ">";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Author>" + this.author + "</Author>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Start>" + this.startEnd[0] + "</Start>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<End>" + this.startEnd[1] + "</End>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Date>" + Utility.calendarToDateString(this.date) + "</Date>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Time>" + Utility.calendarToTimeString(this.date) + "</Time>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Text>" + this.text + "</Text>";
        xml = String.valueOf(xml) + "\n" + indent + "</" + this.type + ">";
        return xml;
    }

    public String toString() {
        String retval = "Clipping[" + this.title + ", " + this.author + ", " + this.startEnd[0] + ", " + this.startEnd[1] + ", " + this.type + ", " + this.date.toString() + ", " + this.text + "]";
        return retval;
    }
}

