/*
 * Decompiled with CFR 0.152.
 */
package WT.Kindle.Clippings;

import WT.Kindle.Clippings.Clipping;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Book {
    private String title;
    private ArrayList<Clipping> clippings;
    private boolean isTitleSet;

    public Book() {
        this.title = "";
        this.clippings = new ArrayList();
        this.isTitleSet = false;
    }

    public Book(String title) {
        this.title = title;
        this.clippings = new ArrayList();
        this.isTitleSet = true;
    }

    public boolean IsTitleSet() {
        return this.isTitleSet;
    }

    public void add(Clipping clipping) {
        if (this.title.equals(clipping.getTitle())) {
            this.clippings.add(clipping);
        }
    }

    public void setTitle(String title) {
        if (!this.isTitleSet) {
            this.title = title;
        }
    }

    public void setClippings(ArrayList<Clipping> clippings) {
        this.clippings = clippings;
    }

    public String getTitle() {
        return this.title;
    }

    public ArrayList<Clipping> getClippings() {
        return this.clippings;
    }

    public String toXML(int indentation) {
        String indent = "";
        int i = 0;
        while (i < indentation) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        String xml = "";
        xml = String.valueOf(xml) + "\n" + indent + "<Book>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Title>" + this.title + "</Title>";
        for (Clipping clipping : this.clippings) {
            xml = String.valueOf(xml) + clipping.toXML(indentation + 1);
        }
        xml = String.valueOf(xml) + "\n" + indent + "</Book>";
        return xml;
    }

    public String toString() {
        String retVal = String.valueOf(this.title) + "(" + this.clippings.size() + ")";
        return retVal;
    }
}

