/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter 
 * to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package WT.Kindle.Clippings;

import java.util.ArrayList;

/// @todo Add licence and copyright

/**
 * @file Book.java
 * @brief This file holds the source code for the Book class.
 * @date Created: 25/08/2011
 * @date Modified: 27/08/2011
 * @author Antony Jordan
 */
/**
 * @class Book
 * @brief The Book class stores all the clippings from a particular book title in a single location.
 * It uses the Clipping class to store the clippings as an object in an ArrayList and stores their common title as a single string.
 * @date Created: 25/08/2011
 * @date Modified: 27/08/2011
 * @author Antony Jordan
 * @todo Add code to handle errors such as incorrect file layout.
 */
public class Book {
	/// @brief A string value to store the common title of all the clippings.
	private String title;
	/// @brief An ArrayList of Clipping to store all of the clippings common to the title.
	private ArrayList<Clipping> clippings;
    /// @brief A boolean value used to check if the title has been set for the book.
	private boolean isTitleSet;
	
	/// @brief This constructor initialises the title to an empty string and the clippings to an empty ArrayList<Clipping>.
    public Book() {
        this.title = "";
        clippings = new ArrayList<Clipping>();
		isTitleSet = false;
    }
	/**
	 * @brief This constructor initialises the title to a given string value and the clippings tp an empty ArrayList<Clipping>.
	 * @param title The given string value for the title.
	 */
    public Book(String title) {
        this.title = title;
        clippings = new ArrayList<Clipping>();
		isTitleSet = true;
    }
	
	/**
	 * @brief Used to check if the books title has been set.
	 * @return True if it has been set False otherwise.
	 */
	public boolean IsTitleSet(){return isTitleSet;}
	
	/**
	 * @brief Adds a single clipping to the book if its title matches the book's.
	 * @param clipping The Clipping to add to the book.
	 */
	public void add(Clipping clipping){
		if(title.equals(clipping.getTitle())){
			clippings.add(clipping);
		}
		else{
			/// @todo Add error handling code
		}
	}
	
	/**
	 * @brief Sets the common title for the clippings.
	 * @param title The String value to set as the title.
	 */
	public void setTitle(String title){
		if(!isTitleSet){
			this.title = title;
		}
		else{
			/// @todo Add error handling code
		}
	}
	/** 
	 * @brief Overwrites the current clippings ArrayList with the one provided.
	 * @param clippings The ArrayList<Clipping> to replace the current one.
	 */
    public void setClippings(ArrayList<Clipping> clippings){this.clippings = clippings;}
    
	/**
	 * @brief Get method to retrieve the common title for the clippings stored.
	 * @return The title common to all the clippings.
	 */
	public String getTitle(){return title;}
	/**
	 * @brief Get method to retrieve the clippings stored.
	 * @return An ArrayList<Clipping> of all the stored clippings..
	 */
	public ArrayList<Clipping> getClippings(){return clippings;}
	
	/**
	 * @brief Outputs the current book and all its clippings in XML format.
	 * @param indentation The number of tabs to indent by.
	 * @return A string containing the XML code.
	 */
	public String toXML(int indentation){
		String indent = "";
		for(int i = 0;i<indentation;i++){indent += "\t";}
		
		String xml = "";
		
		xml += "\n" 	+ indent + "<Book>";
        
        xml += "\n\t" 	+ indent + "<Title>" + title + "</Title>";
        
        for (Clipping clipping : clippings) {
        	xml+=clipping.toXML(indentation + 1);
        }
        
        xml += "\n" 	+ indent + "</Book>";
        
        return xml;
	}
	///@brief Displays the book title along with the number of clippings shown in parenthasis.
	public String toString() {
        String retVal;

        retVal = title + "(" + clippings.size() + ")";

        return retVal;
    }
}
