/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.bitmap;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import java.io.IOException;
import java.io.InputStream;

public class BitmapChecker
implements ContentChecker {
    OCFPackage ocf;
    Report report;
    String path;
    String mimeType;

    BitmapChecker(OCFPackage ocf, Report report, String path, String mimeType) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.mimeType = mimeType;
    }

    private void checkHeader(byte[] header) {
        boolean passed = this.mimeType.equals("image/jpeg") ? header[0] == -1 && header[1] == -40 : (this.mimeType.equals("image/gif") ? header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56 : (this.mimeType.equals("image/png") ? header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71 : true));
        if (!passed) {
            this.report.error(null, 0, "The file " + this.path + " does not appear to be of type " + this.mimeType);
        }
    }

    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, "image file " + this.path + " is missing");
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.error(null, 0, "image file " + this.path + " cannot be decrypted");
        } else {
            try {
                InputStream in = this.ocf.getInputStream(this.path);
                byte[] header = new byte[4];
                if (in.read(header) != header.length) {
                    this.report.error(null, 0, "image file " + this.path + " is too short");
                } else {
                    this.checkHeader(header);
                }
                in.close();
            }
            catch (IOException e) {
                this.report.error(null, 0, "I/O error reading " + this.path);
            }
        }
    }
}

