#!/bin/sh
# ds = current status of duokan process
# ks = current status of kindle process
# status starts with S if the process is active, T if the process is stopped,
# and nothing if the process is not found
eips -c
ds=$(ps -e j | grep -v awk | awk '/KindleApp/ { print $7 }')
ks=$(ps -e j | grep -v awk | awk '/cvm/ { print $7 }')
eips 0 20 "From DS: $ds KS: $ks" 
case $ds in
T*) 
;;
S*) 
dstop=$(killall -STOP KindleApp)
if [$dstop -ne 0 ]
then
eips 0 22 "$dstop Error sending Duokan STOP"
sleep 1
fi
;;
*) 
;;
esac

case $ks in
T*) 
kcont=$(killall -cont cvm)
if [ $kcont -ne 0 ]
then
eips 0 23 "$kcont Error sending Kindle CONT"
sleep 1
fi
;;
S*) 
;;
*) 
/etc/init.d/framework start &
;;
esac

sleep 4
dbus-send --system /default com.lab126.powerd.resuming int32:1
sleep 1
dbus-send --system /default com.lab126.powerd.usbPlugOut int32:1