#!/bin/sh
# ds = current status of duokan process
# ks = current status of kindle process
# status starts with S if the process is active, T if the process is stopped,
# and nothing if the process is not found
eips -c
ds=$(ps -e j | grep -v awk | awk '/KindleApp/ { print $7 }')
ks=$(ps -e j | grep -v awk | awk '/cvm/ { print $7 }')
eips 0 20 "From DS: $ds KS: $ks" 

case $ks in
T*) 
;;
S*) 
kstop=$(killall -STOP cvm)
if [ $kstop -ne 0 ]
then
eips 0 22 "$kstop Error sending Kindle STOP"
sleep 1
fi
;;
*) 
;;
esac

case $ds in
T*)
dcont=$(killall -cont KindleApp)
if [ $dcont -ne 0 ]
then
eips 0 23 "$dcont Error sending Duokan CONT"
sleep 1
fi
;;
S*)
;;
*)
# if duokan lite process not found at all, start it
# environment variables required by duokan lite
SYS_LITE_PATH=/test/DKLite/
USER_LITE_PATH=/mnt/us/DK_System/Lite/
export SYS_LITE_PATH
export USER_LITE_PATH
APP_LITE_NOTFOND_RET=100
APP_EBOOK_NOTFOND_RET=110
DKLITE_PATH=$SYS_LITE_PATH
LITE_CONFIG_INI=$USER_LITE_PATH/config.ini
OLD_LD_LIBRARY_PATH=$LD_LIBRARY_PATH
cd $SYS_LITE_PATH
LD_LIBRARY_PATH=.:$SYS_LITE_PATH/lib/:../lib/:${LD_LIBRARY_PATH}
FONTCONFIG_PATH=$USER_LITE_PATH/res/fontconfig
export LD_LIBRARY_PATH
export FONTCONFIG_PATH
./KindleApp >/mnt/us/dk.log 2>/mnt/us/dk2.log &
export LD_LIBRARY_PATH=$OLD_LD_LIBRARY_PATH
;;
esac
sleep 4
dbus-send --system /default com.lab126.powerd.resuming int32:1
sleep 1
dbus-send --system /default com.lab126.powerd.usbPlugOut int32:1