#!/bin/sh
# ds = current status of duokan process
# ks = current status of kindle process
# status starts with S if the process is active, T if the process is stopped,
# and nothing if the process is not found

ds=$(ps -e j | grep -v awk | awk '/KindleApp/ { print $7 }')
ks=$(ps -e j | grep -v awk | awk '/cvm/ { print $7 }')
case $ds in
T*)
killall -cont KindleApp
;;
S*)
;;
*)
# if duokan lite process not found at all, start it
# environment variables required by duokan lite
SYS_LITE_PATH=/test/DKLite/
USER_LITE_PATH=/mnt/us/DK_System/Lite/
export SYS_LITE_PATH
export USER_LITE_PATH
APP_LITE_NOTFOND_RET=100
APP_EBOOK_NOTFOND_RET=110
DKLITE_PATH=$SYS_LITE_PATH
LITE_CONFIG_INI=$USER_LITE_PATH/config.ini
OLD_LD_LIBRARY_PATH=$LD_LIBRARY_PATH
cd $SYS_LITE_PATH
LD_LIBRARY_PATH=.:$SYS_LITE_PATH/lib/:../lib/:${LD_LIBRARY_PATH}
FONTCONFIG_PATH=$USER_LITE_PATH/res/fontconfig
export LD_LIBRARY_PATH
export FONTCONFIG_PATH
./KindleApp >/mnt/us/dk.log 2>/mnt/us/dk2.log &
export LD_LIBRARY_PATH=$OLD_LD_LIBRARY_PATH
;;
esac

case $ks in
T*) 
;;
S*) 
killall -STOP cvm
;;
*) 
;;
esac


