package com.javese.android.lcd2einkapp;

import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.widget.TextView;


public class LCD2EinkActivity extends Activity {
    private Button captureButton = null;
    private Button RemoveNotificationButton = null; 
    private CheckBox autoModeCheckbox = null;
    public static final String PREF_AUTO_MODE = "PREF_AUTO_MODE";
    
    SharedPreferences prefs;

    NotificationManager localNotificationManager = null;
    int notificationRef = 1;

    Timer timer = null; 
    TimerTask task = null;
    Handler handler = new Handler(){  
    	public void handleMessage(Message msg) {  
    		switch (msg.what) {      
    			case 1:      
                    Intent i = new Intent(LCD2EinkActivity.this, LCD2EinkService.class);
                    i.putExtra("DisableDelay", true);

                    LCD2EinkActivity.this.startService(i);
                    prefs = PreferenceManager.getDefaultSharedPreferences(LCD2EinkActivity.this);
                    boolean autoModeChecked = prefs.getBoolean(PREF_AUTO_MODE, false);
                    if(autoModeChecked)
                    {
                    	timer = new Timer();  
                    	task = new TimerTask(){  
                            public void run() {  
                           	 Message message = new Message();      
                           	 message.what = 1;      
                           	 handler.sendMessage(message);    
                            }
                    	};  
                        timer.schedule(task, 5000);  
                    }
                    
                  break;      
           }      
           super.handleMessage(msg);  
         }  
    };  


	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        
        captureButton =  (Button)findViewById(R.id.button_capture);
        RemoveNotificationButton =  (Button)findViewById(R.id.button_remove_notification); 
        captureButton.setOnClickListener(new Button.OnClickListener(){   
        	public void onClick(View v)  
        	{  
        		Capture();  
        	}  
        });         
        RemoveNotificationButton.setOnClickListener(new Button.OnClickListener(){   
        	public void onClick(View v)  
        	{  
        		RemoveNotification();  
        	}  
        });        
        autoModeCheckbox = (CheckBox)findViewById(R.id.checkBox_automode);
        autoModeCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
        	  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        		     // TODO Auto-generated method stub
        		  Editor editor = prefs.edit();
        		  editor.putBoolean(PREF_AUTO_MODE, isChecked);
        		  editor.commit();
        		     if(isChecked)
        		     {
        		    	 timer = new Timer();  
        		    	 task = new TimerTask(){  
        		             public void run() {  
        		            	 Message message = new Message();      
        		            	 message.what = 1;      
        		            	 handler.sendMessage(message);    
        		             }
        		    	 };  
        		    	 timer.schedule(task, 5000); 
        		     }

        		    }	
        });
        TextView author_version_text  = (TextView)findViewById(R.id.textView_author_version);
        String authorVersionText = getString(R.string.author)+": javese\n"+getString(R.string.version)+": 0.1.2\n";
        author_version_text.setText(authorVersionText);
 

        localNotificationManager = (NotificationManager)getSystemService("notification");
        String str1 = getString(R.string.capture_now);
        long l = System.currentTimeMillis();
        Notification localNotification = new Notification(R.drawable.icon, str1, l);
        localNotification.flags = localNotification.flags | Notification.FLAG_ONGOING_EVENT;
        Intent localIntent1 = new Intent(this, LCD2EinkService.class);
        localIntent1.putExtra("DisableCheck", true);
        PendingIntent localPendingIntent = PendingIntent.getService(this, 0, localIntent1, PendingIntent.FLAG_UPDATE_CURRENT);
        
        localNotification.contentIntent = localPendingIntent;
        String strAppName = getString(R.string.app_name);
    
        localNotification.setLatestEventInfo(this, strAppName, str1, localPendingIntent);
        localNotificationManager.notify(notificationRef, localNotification);
        
        prefs = PreferenceManager.getDefaultSharedPreferences(this);
        boolean autoModeChecked = prefs.getBoolean(PREF_AUTO_MODE, false);
        if(autoModeChecked)
        {
        	autoModeCheckbox.setChecked(true);
        	timer = new Timer();  
        	task = new TimerTask(){  
                public void run() {  
               	 Message message = new Message();      
               	 message.what = 1;      
               	 handler.sendMessage(message);    
                }
        	};  
            timer.schedule(task, 5000);  
        }
        else
        {
        	autoModeCheckbox.setChecked(false);
       }
        
        return;     
    }
    

    public void Capture() { 
    	finish();
    	Log.e("lcd2einkactivity", "capture");
    	// do something useful here 
        Intent i = new Intent(this, LCD2EinkService.class);
        i.putExtra("DisableCheck", true);
        this.startService(i);
    	
    	
    } 
    public void RemoveNotification() { 
    	finish();
        localNotificationManager.cancel(notificationRef);
        
        Intent i = new Intent(this, LCD2EinkService.class);
        this.stopService(i);

        prefs = PreferenceManager.getDefaultSharedPreferences(this);
        boolean autoModeChecked = prefs.getBoolean(PREF_AUTO_MODE, false);
        if(autoModeChecked)
        {
        	timer.cancel();
        }
        android.os.Process.killProcess(android.os.Process.myPid());

        

    	
    	// do something useful here 
   } 
    
}