package com.javese.android.lcd2einkapp;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.Log;
import android.net.Uri;

import java.io.File;



public class LCD2EinkService extends Service {
	
	String appRoot = null;
	/*
	static
	{
	  try
	  {
	    System.loadLibrary("exescreen2pdf");
	  }
	  catch (Throwable localThrowable)
	  {
	    Log.e("lcd2einkservice", "failed loading native library", localThrowable);
	  }
	}
	*/

	
	@Override
	public IBinder onBind(Intent arg0) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void onCreate() {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "OnCreate");
		appRoot = getApplicationContext().getFilesDir().getParent();
	}

	@Override
	public void onStart(Intent intent,int startId) {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "OnStart");
		Log.i("lcd2einkservice,appRoot = ", appRoot);
        
		Process process = null;
		int toUpdate = 0;
		boolean disableCheck = intent.getBooleanExtra("DisableCheck",false);
		boolean disableDelay = intent.getBooleanExtra("DisableDelay",false);
		
		if(disableDelay == false)
		{
			SystemClock.sleep(300);
			Log.i("lcd2einkservice","sleep for 300 ms.");
		}
		String commandStr = "su -c "+appRoot;//
		if(disableCheck)
			commandStr = commandStr +"/lib/libexescreen2pdf.so";
		else
			commandStr = commandStr +"/lib/libexecheckfb.so";
		Log.i("lcd2einkservice,commandStr = ", commandStr);

		try{

//		process = Runtime.getRuntime().exec("su -c "+"\""+appRoot+"/lib/libexescreen2pdf.so "+appRoot+"/files/screen.pdf"+"\"");
	
		process = Runtime.getRuntime().exec(commandStr);
	//	process = Runtime.getRuntime().exec("su -c "+appRoot+"/lib/libexescreen2pdf.so");



		toUpdate = process.waitFor();

		}catch(Exception e){

		   e.printStackTrace();

		}finally {

		   process.destroy();

		}		
		
		if(toUpdate == 1)
			DisplayOnEPaper();
	}
	@Override
	public void onDestroy() {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "onDestroy");
	}
	private void DisplayOnEPaper(){
	    try
	    {
		  String str1 = "/sdcard/public/screen.pdf";
	      File localFile = new File(str1);
	      if(!localFile.exists())
	      {
	    	  str1 = "/intsdcard/public/screen.pdf";
	    	  localFile = new File(str1);
	    	  if(!localFile.exists())
	    		  return; 	  
	      }

	      String str3 = getString(R.string.screen_dump);
	      Intent localIntent1 = new Intent("android.intent.action.VIEW");
	      Uri localUri = Uri.parse(str1);
	      localIntent1.setDataAndType(localUri, "vnd.entourage.book/book");
	      localIntent1.putExtra("entouragesys.intent.extra.READ_ONLY", 0);
	      localIntent1.putExtra("entouragesys.intent.extra.SOURCE", 0);
	      localIntent1.putExtra("entouragesys.intent.extra.BOOK_TITLE", str3);
	      
	      sendBroadcast(localIntent1);
	      String str2 = "Web page file " + str1 + " being displayed on the E-Reader side.";
	      Log.i("WebPage2Epaper", str2);
	      return;
	    }
	    catch (Exception localException)
	    {
	      Log.e("WebPage2Epaper", "Got exception", localException);
	    }
	}
	
/*	private void captureScreen() {
		// TODO: Actions to perform when service is created.
			Log.i("lcd2einkservice", "captureScreen");
		    Bitmap bmp = Bitmap.createBitmap(320, 480, Config.ARGB_8888);
		    View cv = getWindow().getDecorView();
		    cv.draw(new Canvas(bmp));

		    FileOutputStream fos = null;
		    try {
		     fos = new FileOutputStream("/sdcard/screen.jpg");

		     if (fos != null) {
		      bmp.compress(Bitmap.CompressFormat.JPEG, 90, fos);

		      fos.close();
		     }
		    } catch (Exception e) {
		     e.printStackTrace();
		    }
		}
*/

}
