package com.javese.android.lcd2einkapp;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;
import android.net.Uri;
import java.io.File;

public class LCD2EinkService extends Service {
	
	String appRoot = null;
	static
	{
	  try
	  {
	    System.loadLibrary("exescreen2pdf");
	  }
	  catch (Throwable localThrowable)
	  {
	    Log.e("lcd2einkservice", "failed loading native library", localThrowable);
	  }
	}

	
	@Override
	public IBinder onBind(Intent arg0) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void onCreate() {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "OnCreate");
		appRoot = getApplicationContext().getFilesDir().getParent();
	}

	@Override
	public void onStart(Intent intent,int startId) {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "OnStart");
		Log.i("lcd2einkservice,appRoot = ", appRoot);
		Process process = null;
		
		
		try{

//		process = Runtime.getRuntime().exec("su -c "+"\""+appRoot+"/lib/libexescreen2pdf.so "+appRoot+"/files/screen.pdf"+"\"");
		process = Runtime.getRuntime().exec("su -c "+appRoot+"/lib/libexescreen2pdf.so");

		process.waitFor();

		}catch(Exception e){

		   e.printStackTrace();

		}finally {

		   process.destroy();

		}		
		
		
		DisplayOnEPaper();
	}
	@Override
	public void onDestroy() {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "onDestroy");
	}
	private void DisplayOnEPaper(){
	    try
	    {
		  String str1 = "/sdcard/public/screen.pdf";
	      File localFile = new File(str1);
	      if(!localFile.exists())
	      {
	    	  str1 = "/intsdcard/public/screen.pdf";
	    	  localFile = new File(str1);
	    	  if(!localFile.exists())
	    		  return; 	  
	      }

	      String str3 = getString(R.string.screen_dump);
	      Intent localIntent1 = new Intent("android.intent.action.VIEW");
	      Uri localUri = Uri.parse(str1);
	      localIntent1.setDataAndType(localUri, "vnd.entourage.book/book");
	      localIntent1.putExtra("entouragesys.intent.extra.READ_ONLY", 0);
	      localIntent1.putExtra("entouragesys.intent.extra.SOURCE", 0);
	      localIntent1.putExtra("entouragesys.intent.extra.BOOK_TITLE", str3);
	      
	      sendBroadcast(localIntent1);
	      String str2 = "Web page file " + str1 + " being displayed on the E-Reader side.";
	      Log.i("WebPage2Epaper", str2);
	      return;
	    }
	    catch (Exception localException)
	    {
	      Log.e("WebPage2Epaper", "Got exception", localException);
	    }
	}

}
