package com.javese.android.lcd2einkapp;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.widget.TextView;


public class LCD2EinkActivity extends Activity {
    private Button captureButton = null;
    private Button RemoveNotificationButton = null; 
    NotificationManager localNotificationManager = null;
    int notificationRef = 1;


	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        captureButton =  (Button)findViewById(R.id.button_capture);
        RemoveNotificationButton =  (Button)findViewById(R.id.button_remove_notification); 
        captureButton.setOnClickListener(new Button.OnClickListener(){   
        	public void onClick(View v)  
        	{  
        		Capture();  
        	}  
        });         
        RemoveNotificationButton.setOnClickListener(new Button.OnClickListener(){   
        	public void onClick(View v)  
        	{  
        		RemoveNotification();  
        	}  
        });        
        
        TextView author_version_text  = (TextView)findViewById(R.id.textView_author_version);
        String authorVersionText = getString(R.string.author)+": javese\n"+getString(R.string.version)+": 0.1.0\n";
        author_version_text.setText(authorVersionText);
 

        localNotificationManager = (NotificationManager)getSystemService("notification");
        String str1 = getString(R.string.capture_now);
        long l = System.currentTimeMillis();
        Notification localNotification = new Notification(R.drawable.icon, str1, l);
        localNotification.flags = localNotification.flags | Notification.FLAG_ONGOING_EVENT;
        Intent localIntent1 = new Intent(this, LCD2EinkService.class);
        PendingIntent localPendingIntent = PendingIntent.getService(this, 0, localIntent1, PendingIntent.FLAG_UPDATE_CURRENT);
        
        localNotification.contentIntent = localPendingIntent;
        String strAppName = getString(R.string.app_name);
    
        localNotification.setLatestEventInfo(this, strAppName, str1, localPendingIntent);
        localNotificationManager.notify(notificationRef, localNotification);
        
        return;     
    }
    

    public void Capture() { 
    	finish();
    	Log.e("lcd2einkactivity", "capture");
    	// do something useful here 
        Intent i = new Intent(this, LCD2EinkService.class);
        this.startService(i);
    	
    	
    } 
    public void RemoveNotification() { 
    	finish();
        localNotificationManager.cancel(notificationRef);
        
        Intent i = new Intent(this, LCD2EinkService.class);
        this.stopService(i);
    	
    	// do something useful here 
   } 
    
}