var Core = params.Core;

//return file's content in a string
var fileToString = function(path) {
    return Core.io.getFileContent(path, null);
};
//run a command and return the result
var runCommandResult = function(text) {
    if ((kbook == undefined) || false) {
        //@@@simulation mode
        return "command result\nand second line as well:)";
    } 
    
    var tmpf = "/tmp/__shell_result__";
    runCommand(text + " >" + tmpf);

    var res = fileToString(tmpf);
    this.issue = res;

    FileSystem.deleteFile(tmpf);
    return res;
};

//put text into /tmp/script.sh and run it
var runCommand = function(text) {
    Core.shell.exec(text);

};

//append text to result window and scroll to end
target.appendText = function(text) {
    //@@@ this.textlines.insert(res);
    //var fnInsert = Core.system.getSoValue(this.textlines, 'insert');
    //fnInsert.call(this.textlines, text);
    this.textlines.setValue(this.textlines.getValue() + text);
    var fnscrollSelection = Core.system.getSoValue(this.textlines, 'scrollSelection');
    fnscrollSelection.call(this.textlines);
};

/********************************************************
*   button processing
*********************************************************/

//Center Key (indirectly doKbdInput)
//process command, put it into command queue as well
target.centerKey = function() {
    var cmd = this.inputLine.getValue();
    var res;
    try {
        res = runCommandResult(cmd);
    }
    catch (e) {
        res = e;
    }
    this.appendText(cmd + '\n' + res);
}

//Next key 
//enable keyboard
target.kbdEnable = function() {
    VirtualKeyboard.Activate(this, this.kbd);
    this.textlines.changeLayout(10, undefined, 10, 60, undefined, 315);
    VirtualKeyboard.SetInput(this.inputLine.getValue());
};

//Previous key, doKbdCancel 
//disable keyboard
target.kbdDisable = function() {
    VirtualKeyboard.Deactivate();
    this.textlines.changeLayout(10, undefined, 10, 60, undefined, 10);
};

//application initialization
target.init = function() {
    this.showHelp();
};

//Menu key
//exit
target.exitApp = function () {
	kbook.autoRunRoot.exitIf(kbook.model);
};

//Up/Down buttons
//scroll up/down page
target.scrollText = function(by) {
    var fnPageScroll = Core.system.getSoValue(this.textlines, 'scrollPage');
    fnPageScroll.call(this.textlines, true, by);
};

//Size button
//show help
target.showHelp = function() {
    var help = '';
    help += '-------- HELP --------\n';
    help += 'Prev/Next = disable/enable keyboard\n';
    help += 'Center key = execute\n';
    help += 'Up/Down = scroll up/down\n';
    help += 'Size = show help\n';
    help += 'Size-hold = clear result window\n';
    help += 'Menu = exit\n';
    help += '----------------------\n';
    this.appendText(help);
};