// diagnose.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "main.h"
#include "regscan.h"

// Forward declarations of functions included in this code module:
BOOL CALLBACK DlgProc(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPTSTR    lpCmdLine,
	int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	// TODO: Place code here.

	INITCOMMONCONTROLSEX init_common_controls_ex;
	ZeroMemory(&init_common_controls_ex, sizeof(init_common_controls_ex));
	init_common_controls_ex.dwSize = sizeof(init_common_controls_ex);
	init_common_controls_ex.dwICC = ICC_STANDARD_CLASSES | ICC_PROGRESS_CLASS | ICC_LINK_CLASS; 
	InitCommonControlsEx(&init_common_controls_ex);

	HWND hDlg = CreateDialogW(hInstance, MAKEINTRESOURCE(IDD_MAIN), 0, DlgProc);

	initialize_registry_scanner(hDlg);

	ShowWindow(hDlg, nCmdShow);
	UpdateWindow(hDlg);

	_beginthread(start_registry_scan, 0, NULL);

	MSG msg;

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) {
		if (!IsDialogMessage(hDlg, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}

BOOL CALLBACK DlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{

	case WM_INITDIALOG:
		ShowWindow(GetDlgItem(hDlg, IDOK), SW_HIDE);
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
			DestroyWindow(hDlg);
			return TRUE;
		case IDCANCEL:
			cancel_registry_scan(NULL);
			return TRUE;
		}
		return FALSE;

	case WM_NOTIFY:
		switch (((LPNMHDR)lParam)->code)
		{
	    case NM_CLICK:    
	    case NM_RETURN:
            if (((LPNMHDR)lParam)->hwndFrom == GetDlgItem(hDlg, IDC_SYSLINK))
			{
				// spawn notepad to show the report.
				_wspawnlp(_P_NOWAIT, L"notepad.exe", L"notepad.exe", get_report_filename().c_str(), NULL);
				return TRUE;
			}
            break;
        }
		return FALSE;

	case WM_CLOSE:
		cancel_registry_scan(NULL); // in case
		DestroyWindow(hDlg);
		return TRUE;

	case WM_DESTROY:
		PostQuitMessage(0);
		return TRUE;

	default:
		return FALSE;
	}
}
