# convert the given .opf and  file to kindlegen expected format
# Usage: convertKG INOPFFILE INNCXFILE OUTOPFFILE OUTNCXFILE
from BeautifulSoup import BeautifulSoup
from BeautifulSoup import MinimalSoup
from BeautifulSoup import BeautifulStoneSoup
from BeautifulSoup import ICantBelieveItsBeautifulSoup
import re, sys

# avoid navpoint tag to be auto-rearrange
BeautifulStoneSoup.NESTABLE_TAGS["navpoint"] = []
BeautifulStoneSoup.NESTABLE_TAGS["navlabel"] = []
BeautifulStoneSoup.NESTABLE_TAGS["text"] = []
BeautifulStoneSoup.NESTABLE_TAGS["content"] = []

INOPFFILE = sys.argv[1]
INNCXFILE = sys.argv[2]
OUTOPFFILE = sys.argv[3]
OUTNCXFILE = sys.argv[4]

# opf file
inFile = open(INOPFFILE, 'rU')
soup = BeautifulStoneSoup(''.join(inFile))
inFile.close()
# TODO: move <dc:title> up from <meta name="calibre:timestamp"> tag
soup.metadata.insert(0, soup.find('dc:title'))
# TODO: move <dc:date> up from <meta name="cover"> tag
soup.metadata.insert(0, soup.find('dc:date'))
# add x-metadata
soup.find('metadata').insert(0, "<x-metadata><output encoding=\"utf-8\" Content-type=\"application/x-mobipocket-subscription-magazine\"/></x-metadata>")
# make appropriate guide entries
soup.find('guide').replaceWith("<guide><reference type=\"start\" title=\"start\" href=\"index.html\"/><reference type=\"toc\" title=\"toc\" href=\"index.html\"/><reference type=\"text\" title=\"text\" href=\"index.html\"/></guide>")
# write the output
outFile = open(OUTOPFFILE, 'w')
outFile.write(soup.prettify())		
outFile.close()

# ncx file
inFile = open(INNCXFILE, 'rU')
soup = BeautifulStoneSoup(''.join(inFile), selfClosingTags=['content'])
inFile.close()

# obtain navMap node
# set 1st layer's chapters to sections, 2nd layer's chapters to articles
navMap = soup.find('navmap')
outerNavPoints = navMap.findAll('navpoint', recursive=False)
for i in outerNavPoints:
	i['class'] = 'section'
	innerNavPoints = i.findAll('navpoint')
	for j in innerNavPoints:
		j['class'] = 'article'

# embrace the original with periodical class
newNavMap = BeautifulStoneSoup(''.join("<navmap><navpoint class=\"periodical\"><navlabel><text>Periodical</text></navlabel><content src=\"index.html\"></navpoint></navmap>"))
i = 0
items = navMap.findChildren(recursive=False)	
for item in items:
	newNavMap.navpoint.insert(i, item)
	i = i + 1
newNavMap.navpoint.insert(0, BeautifulStoneSoup("<mbp:meta-img name=\"mastheadImage\" src=\"mastheadImage.jpg\"/>", selfClosingTags=['mbp']));
soup.find('navmap').replaceWith(newNavMap)
outFile = open(OUTNCXFILE, 'w')
outFile.write(soup.prettify())
outFile.close()
