# remove the <div class="calibrenavbar"> tags in all the html files

import os, sys
import glob
from BeautifulSoup import BeautifulSoup

path = sys.argv[1]
exception = 'index.html'

def scandirs(path):
	for currentFile in glob.glob(os.path.join(path, '*')):
		if os.path.isdir(currentFile):
			scandirs(currentFile)
		# only works with .html file
		if currentFile.endswith('.html'): 
			print "processing file: " + currentFile
			inFile = open(currentFile, 'rU')
			soup = BeautifulSoup(''.join(inFile))
			inFile.close()
			horbars = soup.findAll('hr')
			for horbar in horbars:
				horbar.extract()
			navbars = soup.findAll('div', attrs={'class': "calibrenavbar"})
			for navbar in navbars:
				navbar.extract()
			empty_tags = soup.findAll(lambda tag: tag.name == 'p' and (tag.string is None or not tag.string.strip()))
			for empty_tag in empty_tags:
				empty_tag.extract()
			outFile = open(currentFile, 'w')
			outFile.write(soup.prettify())
			outFile.close()

# only deal with folders of the given folder
for i in glob.glob(os.path.join(path, '*')):
	if os.path.isdir(i):	
		scandirs(i)


