Sub transform_html()
' Deze macro zet het active document om in een document met HTML tags als opmaak.
' Versie 1.1 - Toxaris

    ActiveDocument.Save 'Opslaan huidige document
    Application.ScreenUpdating = False 'scherm updates uitschakelen tijdens macro

    'Uitvoeren functies...
    replace_headers 'vervangen kopteksten
    replace_formating 'vervangen schuin, vet en onderstreept
    replace_notes 'omzeten voet- en eindnoten
    replace_lists 'omzetten eenvoudige 1 niveau lijsten
    replace_tables 'omzetten van tabellen
    replace_hyper 'omzetten hyperlinks
    replace_pics 'exporteren en omzetten afbeeldingen
    replace_customparagraphs 'omzetten eigen stijlen
    replace_formated_paragraphs 'omzetten paragrafen met opmaak
    replace_empty_paragraphs 'omzetten geplande witregels
    replace_other_paragraphs 'omzetten restant paragrafen
    place_headerfooter 'HTML header neerzetten
    saveashtml 'aanpassing opslaan
    
    Application.ScreenUpdating = True
End Sub

Function replace_headers()
' omzetten kopteksten naar HTML code
Dim i, headnum As Integer

For i = -2 To -7 Step -1
headcount = Abs(i) - 1
    Selection.HomeKey wdStory ' Ga naar begin dokument
    Selection.Find.ClearFormatting ' Vorige opmaak wissen in selectie
    Selection.Find.Style = ActiveDocument.Styles(i) 'alleen zoeken op kopteksten stijl
    Selection.Find.Text = "" ' Naar willekeurige tekst zoeken, hele header nodig
        Do While Selection.Find.Execute = True ' Voer de vervangingen uit
            If Selection.Characters.Count > 1 Then ' Lege headers afvangen
                While Selection.Characters.Last = " " Or Selection.Characters.Last = vbCr
                    Selection.MoveEnd Unit:=wdCharacter, Count:=-1 ' de enter niet meeselecteren
                Wend
            Selection.InsertBefore "<h" & headnum & ">"
            Selection.InsertAfter "</h" & headnum & ">"
            Selection.Find.Replacement.ClearFormatting
            End If
        Selection.Style = -1 'maak er normale opmaak van om verdere selectie te voorkomen
        Selection.MoveRight wdCharacter, 1
        Loop
Next i

End Function

Function replace_formating()
' Deze macro zoekt in de tekst naar willekeurige tekst in italic, vet of onderstreept en zet deze om in HTML
Selection.HomeKey wdStory ' Ga naar begin dokument
Selection.Find.ClearFormatting ' Vorige opmaak wissen
Selection.Find.Font.Italic = True ' Zoeken naar Italic
Selection.Find.Text = "" ' Naar willekeurige tekst zoeken
Do While Selection.Find.Execute = True ' Voer de vervangingen uit
    Selection.Font.Italic = False 'Alvast opmaak uitzetten om loop te voorkomen
    While Selection.Characters.Last = " " Or Selection.Characters.Last = vbCr
        Selection.MoveEnd Unit:=wdCharacter, Count:=-1 ' de enter niet meeselecteren
    Wend
    Selection.InsertBefore "<i>"
    Selection.InsertAfter "</i>"
    
    Selection.MoveRight wdCharacter, 1
Loop

Selection.HomeKey wdStory ' Ga naar begin dokument
Selection.Find.ClearFormatting ' Vorige opmaak wissen
Selection.Find.Font.Bold = True ' Zoeken naar vetgedrukt
Selection.Find.Text = "" ' Naar willekeurige tekst zoeken
Do While Selection.Find.Execute = True ' Voer de vervangingen uit
    Selection.Font.Bold = False 'Alvast opmaak uitzetten om loop te voorkomen
    While Selection.Characters.Last = " " Or Selection.Characters.Last = vbCr
        Selection.MoveEnd Unit:=wdCharacter, Count:=-1 ' de enter niet meeselecteren
    Wend
    Selection.InsertBefore "<b>"
    Selection.InsertAfter "</b>"
    Selection.MoveRight wdCharacter, 1
Loop

Selection.HomeKey wdStory ' Ga naar begin dokument
Selection.Find.ClearFormatting ' Vorige opmaak wissen
Selection.Find.Font.Underline = True ' Zoeken naar vetgedrukt
Selection.Find.Text = "" ' Naar willekeurige tekst zoeken
Do While Selection.Find.Execute = True ' Voer de vervangingen uit
    Selection.Font.Underline = False 'Alvast opmaak uitzetten om loop te voorkomen
    While Selection.Characters.Last = " " Or Selection.Characters.Last = vbCr
        Selection.MoveEnd Unit:=wdCharacter, Count:=-1 ' de enter niet meeselecteren
    Wend
    Selection.InsertBefore "<u>"
    Selection.InsertAfter "</u>"
    Selection.MoveRight wdCharacter, 1
Loop

End Function

Function replace_notes()
' Voetnoten omzetten in eindnoten
' Eindnoten omzetten in HTML code met referenties.
Dim num As Long
Dim myString As String

With ActiveDocument.Sections.Last.Range 'Naar het eind van het document gaan
    .Collapse Direction:=wdCollapseEnd
    .InsertParagraphAfter 'Enter geven aan het eind voor onderscheid
    .InsertAfter "<hr />" & vbCr 'onderscheid tussen tekst en noten
    Selection.EndKey Unit:=wdStory
    Selection.ClearFormatting
End With

If ActiveDocument.Footnotes.Count > 0 Then
    ActiveDocument.Footnotes.Convert 'omzetten voetnoten in eindnoten als ze er zijn
End If
        
If ActiveDocument.Endnotes.Count = 0 Then
    Exit Function
End If

With Selection
    .HomeKey wdStory
    For num = 1 To ActiveDocument.Endnotes.Count
        .GoToNext wdGoToEndnote 'ga naar de eerste eindnote
        .TypeText Text:="<a href=" & Chr(34) & "#edn" & CStr(num) & Chr(34) & " name=" & Chr(34) & "endref" & CStr(num) & Chr(34) & "><sup>" & CStr(num) & "</sup></a>" 'vervang de eindnote in een HTML referentie
        .Expand wdWord 'ga naar het eind van het document
        With ActiveDocument.Endnotes(1) 'doordat de verwerkte eindnote verwijderd wordt, blijven we de eerste note verwerken
            myString = myString & "<a href=" & Chr(34) & "#ednref" & CStr(num) & Chr(34) & " name=" & Chr(34) & "end" & CStr(num) & Chr(34) & "><sup>" & CStr(num) & "</sup></a>" & ". " & .Range.Text & vbCrLf 'plaats de HTML referentie en plaats de tekst van de eindnote in een string
            .Delete 'gooi de eindnote weg.
        End With
    Next
    .EndKey wdStory
    .InsertAfter myString
    .Collapse Direction:=wdCollapseEnd
End With

End Function

Function replace_lists()
' omzetten eenvoudige lijsten (1 niveau!)
Dim lijst As List
Dim para As Paragraph
Dim i As Long

For Each para In ActiveDocument.ListParagraphs 'alle lijst items nagaan
    With para.Range
    For i = 1 To .ListFormat.ListLevelNumber
        .MoveEnd Unit:=wdCharacter, Count:=-1 'enter niet meenemen
        .InsertBefore "<li>" 'HTML code begin item
        .InsertAfter "</li>" 'HTML code eind item
    Next i
    End With
Next para

For Each lijst In ActiveDocument.Lists 'alle lijsten nagaan
    With lijst.Range
        .MoveEnd Unit:=wdCharacter, Count:=-1 'enter niet meenemen
        If .ListFormat.ListType = wdListBullet Then
            .InsertBefore "<ul>" & vbCr 'als het een bullet lijst is, er een ongeordende lijst van maken
            .InsertAfter "</ul>"
        Else
            .InsertBefore "<ol>" & vbCr 'als het een genummerde lijst is, er een geordende lijst van maken
            .InsertAfter "</ol>"
        End If
        .ListFormat.RemoveNumbers 'zet de lijst om in normale tekst
    End With
Next lijst

End Function

Function replace_tables()
' omzetten tabellen
Dim oRow As Row
Dim oCell As Cell
Dim sCellText As String
Dim tTable As Table
Dim noRows, noCells As Long
   
For Each tTable In ActiveDocument.Tables 'elke tabel afwerken
    For Each oRow In tTable.Rows 'per regel door de tabel heengaan
        For Each oCell In oRow.Cells 'per cel door de regel heengaan
            sCellText = oCell.Range
            sCellText = Left$(sCellText, Len(sCellText) - 2) 'cel opmaakcode verwijderen
            If Len(sCellText) = 0 Then sCellText = "&nbsp;" 'in geval van een lege cel
            sCellText = "<td>" & sCellText & "</td>" 'HTML code toevoegen
            oCell.Range = sCellText 'pas de waarde in de cel aan
        Next oCell
        sCellText = oRow.Cells(1).Range 'selecteer de tekst uit de eerste cel v.d. regel
        sCellText = Left$(sCellText, Len(sCellText) - 2) 'cel opmaakcode verwijderen
        sCellText = "<tr>" & vbCr & sCellText 'HTML code toevoegen, begin van tabelregel
        oRow.Cells(1).Range = sCellText 'pas de waarde in de cel aan
        sCellText = oRow.Cells(oRow.Cells.Count).Range 'selecteer de tekst uit de laatste cel v.d. regel
        sCellText = Left$(sCellText, Len(sCellText) - 2) 'cel opmaakcode verwijderen
        sCellText = sCellText & vbCr & "</tr>" 'HTML code toevoegen, einde van tabelregel
        oRow.Cells(oRow.Cells.Count).Range = sCellText 'pas de waarde in de cel aan
    Next oRow
    sCellText = tTable.Rows(1).Cells(1).Range 'tekst van de eerste cel van de tabel selecteren
    sCellText = Left$(sCellText, Len(sCellText) - 2) 'cel opmaakcode verwijderen
    sCellText = "<table>" & vbCr & sCellText 'HTML code toevoegen, begin van de tabel
    tTable.Rows(1).Cells(1).Range = sCellText 'pas de waarde in de cel aan
    noRows = tTable.Rows.Count 'aantal regels in de tabel
    noCells = tTable.Rows(noRows).Cells.Count 'aantal cellen in de tabel
    sCellText = tTable.Rows(noRows).Cells(noCells).Range 'selecteer tekst van de allerlaatste cel
    sCellText = Left$(sCellText, Len(sCellText) - 2) 'cel opmaakcode verwijderen
    sCellText = sCellText & vbCr & "</table>" 'HTML code toevoegen, eind van de tabel
    tTable.Rows(noRows).Cells(noCells).Range = sCellText 'pas de waarde in de cel aan
    
    tTable.ConvertToText Separator:=wdSeparateByParagraphs 'tabel omzetten naar tekst met enter als scheiding
Next tTable

End Function

Function replace_hyper()
'Omzetten hyperlinks
Dim hyperCount, i As Long
Dim addr As String

hyperCount = ActiveDocument.Hyperlinks.Count
If hyperCount > 0 Then
    For i = 1 To hyperCount
        With ActiveDocument.Hyperlinks(1) 'alle hyperlinks afgaan
            addr = .Address 'Selecteer hyperlink doel
            .Delete 'Verwijder hyperlink, niet de tekst!
            .Range.InsertBefore "<a href=" & Chr(34) & addr & Chr(34) & ">" 'plaats HTML link
            .Range.InsertAfter "</a>"
        End With
    Next i
End If

End Function

Function replace_pics()
Dim sDir
Dim iDir, num As Integer
Dim oPlaatje As Word.InlineShape                      ' Word Shape Object
Dim HuidigeMap, ExportMap As String
Dim imgname, oldname As String

HuidigeMap = ActiveDocument.Path 'Directory van huidige bestand
ExportMap = HuidigeMap & "\Save_As_HTML_files\" 'Directory waar de plaatjes tijdelijk worden opgeslagen

On Error Resume Next
Kill HuidigeMap & "\Save_As_HTML.html" 'Export bestand verwijderen

On Error Resume Next
Kill ExportMap & "*.*" 'Inhoud export directory verwijderen

On Error Resume Next
RmDir ExportMap 'Export directory verwijderen
    
Application.Documents.Add ActiveDocument.FullName 'Kopieer huidige bestand
ActiveDocument.SaveAs HuidigeMap & "\Save_As_HTML.html", FileFormat:=wdFormatHTML 'Sla bestand op als HTML in tijdelijke directory
ActiveDocument.Close 'Sluit tijdelijke kopie

num = 1
For Each oPlaatje In ActiveDocument.InlineShapes 'alle plaatjes nalopen in document
   With oPlaatje.Range
       imgname = "image" & Format(num, "000") & ".jpg" 'nieuwe namen van de plaatjes
       oldname = ExportMap & "image" & Format(num, "000") & ".jpg" 'naam van de plaatjes in de export
       .InsertBefore "<img src=" & Chr(34) & imgname & Chr(34) & " />" 'HTML tag in document
       oPlaatje.Delete 'Verwijder plaatje in document
       imgname = HuidigeMap & "\" & imgname 'naam van plaatje inclusief directory van het document
       FileCopy oldname, imgname 'verplaats plaatje van export directory naar huidige directory
       num = num + 1
   End With
Next

On Error Resume Next
Kill HuidigeMap & "\Save_As_HTML.html" 'tijdelijke export weggooien

On Error Resume Next
Kill ExportMap & "*.*" 'tijdelijke export weggooien

On Error Resume Next
RmDir ExportMap 'tijdelijke export weggooien

End Function

Function replace_customparagraphs()
' TBD: popup for changin other styles to normal
' afbeeldingen gaat voorlopig niet lukken
Dim answer, invoer As String

answer = vbYes

Do While answer <> vbNo
    answer = MsgBox("Andere paragraaf stijlen omzetten?", vbQuestion + vbYesNo, "Paragrafen")
    If answer = vbNo Then Exit Function

    invoer = InputBox("Welke stijl?")

    Selection.HomeKey wdStory ' Ga naar begin dokument
    Selection.Find.ClearFormatting ' Vorige opmaak wissen
    Selection.Find.Style = ActiveDocument.Styles(invoer)
    Selection.Find.Text = "" ' Naar willekeurige tekst zoeken
    Do While Selection.Find.Execute = True ' Voer de vervangingen uit
        While Selection.Characters.Last = " " Or Selection.Characters.Last = vbCr
            Selection.MoveEnd Unit:=wdCharacter, Count:=-1
        Wend
    Selection.InsertBefore "<p class=" & Chr(34) & invoer & Chr(34) & ">" ' de stijlnaam verwijst naar stijlsheet class
    Selection.InsertAfter "</p>"
    Selection.Find.Replacement.ClearFormatting
    Selection.Style = -1
    Selection.MoveRight wdCharacter, 1
    Loop
Loop

End Function

Function replace_formated_paragraphs()
'paragrafen die starten met een html code mbt opmaak (i, b, u)

Selection.HomeKey wdStory ' Ga naar begin dokument
Selection.Find.ClearFormatting ' Vorige opmaak wissen
Selection.Find.MatchWildcards = True
Selection.Find.Text = "^13\<[iuba]*^13" ' Naar paragraaf zoeken die begint met schuin, vet, onderstreept of een link
Do While Selection.Find.Execute = True ' Voer de vervangingen uit
    While Selection.Characters.Last = " " Or Selection.Characters.Last = vbCr
        Selection.MoveEnd Unit:=wdCharacter, Count:=-1
    Wend
    Selection.MoveStart Unit:=wdCharacter, Count:=1
    Selection.InsertBefore "<p>"
    Selection.InsertAfter "</p>"
    Selection.Style = -1
    Selection.MoveRight wdCharacter, 1
Loop

End Function

Function replace_empty_paragraphs()
'vervangen geplande witregels

Selection.HomeKey wdStory ' Ga naar begin dokument
Selection.Find.ClearFormatting ' Vorige opmaak wissen
Selection.Find.MatchWildcards = True
Selection.Find.Text = "^13^13" ' Naar lege paragraaf zoeken
Do While Selection.Find.Execute = True ' Voer de vervangingen uit
    Selection.MoveStart Unit:=wdCharacter, Count:=1
        Selection.InsertBefore "<p>&nbsp;</p>"
    Selection.Style = -1
    Selection.MoveRight wdCharacter, 1
Loop

End Function

Function replace_other_paragraphs()
'overgebleven paragrafen, degene die beginnen met een tag worden overgeslagen

Selection.HomeKey wdStory ' Ga naar begin dokument
Selection.Find.ClearFormatting ' Vorige opmaak wissen
Selection.Find.MatchWildcards = True
Selection.Find.Text = "^13[A-Z]*^13" ' Naar willekeurige tekst zoeken
Do While Selection.Find.Execute = True ' Voer de vervangingen uit
    While Selection.Characters.Last = " " Or Selection.Characters.Last = vbCr
        Selection.MoveEnd Unit:=wdCharacter, Count:=-1
    Wend
    Selection.MoveStart Unit:=wdCharacter, Count:=1 'eerste karakter is enter van vorige regel. Moeten een verder zijn.
    Selection.InsertBefore "<p>"
    Selection.InsertAfter "</p>"
    Selection.Style = -1
    Selection.MoveRight wdCharacter, 1
Loop

End Function

Function place_headerfooter()
Dim MyText, invoer As String
Dim MyRange As Object

Set MyRange = ActiveDocument.Range
invoer = InputBox("Naam externe stylesheet?")
MyText = "<html>" & vbCr & "<head>" & vbCr & "<link rel=" & Chr(34) & "stylesheet" & Chr(34) & " type=" & Chr(34) & "text/css" & Chr(34) & " href=" & Chr(34) & "..\Style\" & invoer & Chr(34) & ">" & vbCr & "</head>" & vbCr & "<body>" & vbCr
MyRange.InsertBefore (MyText)
MyText = "</body>" & vbCr & "</html>"
MyRange.InsertAfter (MyText)

End Function

Function saveashtml()
Dim bestandsnaam, answer As String
Dim extPos As Integer
 
 answer = MsgBox("HTML opslaan?", vbQuestion + vbYesNo, "Opslaan")
If answer = vbNo Then Exit Function

    
extPos = InStrRev(ActiveDocument.FullName, ".") 'de laatste punt zoeken van de extensie. Deze kan namelijk 3 of 4 zijn.
bestandsnaam = Left(ActiveDocument.FullName, extPos - 1) & ".html"
ActiveDocument.SaveEncoding = msoEncodingUTF8
ActiveDocument.SaveAs FileName:=bestandsnaam, FileFormat:=wdFormatText

MsgBox "Bestand opgeslagen als " & bestandsnaam, vbInformation + vbOKOnly, "Klaar!"

End Function

