#!/bin/sh

ROOT=/media/mmcblk0p1/Programs/_dr800+


######################################################################
#####
backup_orig_firmware () {
    cp /usr/bin/uds                          $ROOT/orig/progs
    cp /usr/bin/ctb                          $ROOT/orig/progs
    cp /usr/bin/mdbindex                     $ROOT/orig/progs
    cp /usr/bin/popupmenu                    $ROOT/orig/progs
    cp /usr/bin/erbrowser                    $ROOT/orig/progs
    cp /usr/bin/notepad                      $ROOT/orig/progs
    cp /usr/lib/libermetadb.so.0.0.0         $ROOT/orig/libs
    cp /usr/share/ctb/ctb.rc                 $ROOT/orig/rc
    cp /usr/share/uds/uds.rc                 $ROOT/orig/rc
    cp /usr/share/themes/iRex/gtk-2.0/gtkrc  $ROOT/orig/rc
    cp /usr/share/ctb/icon-shortcuts-*.png   $ROOT/orig/ctb_icons
}

install_dr800plus () {
    cp $ROOT/new/progs/uds.dr1000                  /usr/bin/uds
    cp $ROOT/new/progs/ctb.dr800+                  /usr/bin/ctb
    cp $ROOT/new/progs/mdbindex.dr800+             /usr/bin/mdbindex
    cp $ROOT/new/progs/popupmenu.dr800+            /usr/bin/popupmenu
    cp $ROOT/new/progs/erbrowser.dr800+            /usr/bin/erbrowser
    cp $ROOT/new/progs/notepad.dr800+              /usr/bin/notepad
    cp $ROOT/new/libs/libermetadb.so.0.0.0.dr800+  /usr/lib/libermetadb.so.0.0.0
    cp $ROOT/new/rc/ctb.rc.dr800+                  /usr/share/ctb/ctb.rc
    cp $ROOT/new/rc/uds.rc.dr800+                  /usr/share/uds/uds.rc
    cp $ROOT/new/rc/gtkrc.dr800+                   /usr/share/themes/iRex/gtk-2.0/gtkrc
    cp $ROOT/new/popupmenu_icons/toolbar_*.png     /usr/share/icons
    cp $ROOT/new/ctb_icons/icon-*.png              /usr/share/ctb
    cp $ROOT/new/ctb_settings_icons/icon-*.png     /usr/share/ctb/settings
    cp $ROOT/new/sysinfo                           /usr/bin/sysinfo
    cp $ROOT/new/sysinfo.png                       /usr/share/icons/sysinfo.png
}

restore_orig_firmware () {
    cp $ROOT/orig/progs/*          /usr/bin/
    cp $ROOT/orig/libs/*           /usr/lib/
    cp $ROOT/orig/rc/ctb.rc        /usr/share/ctb/ctb.rc
    cp $ROOT/orig/rc/uds.rc        /usr/share/uds/uds.rc
    cp $ROOT/orig/rc/gtkrc         /usr/share/themes/iRex/gtk-2.0/gtkrc
    cp $ROOT/orig/ctb_icons/*.png  /usr/share/ctb
    rm /usr/share/ctb/icon-recent2-*.png   >/dev/null 2>&1
    rm /usr/share/ctb/settings/icon-*.png  >/dev/null 2>&1
    rm /usr/share/icons/toolbar_*.png      >/dev/null 2>&1
    rm /usr/bin/sysinfo                    >/dev/null 2>&1
    rm /usr/share/icons/sysinfo.png        >/dev/null 2>&1
}

install_schema () {
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    cp -f $ROOT/installfiles/dr800+.schemas /etc/gconf/schemas/dr800+.schemas
    gconftool-2 --makefile-install-rule /etc/gconf/schemas/dr800+.schemas      >/dev/null 2>&1
    # if the schema was already installed make sure it gets the correct value
    gconftool-2 --type bool --set /apps/er/dr800plus/show_taskbar "false"      >/dev/null 2>&1
    gconftool-2 --type int  --set /apps/er/dr800plus/num_recent_items "15"     >/dev/null 2>&1
    gconftool-2 --type bool --set /apps/er/dr800plus/disable_indexing "false"  >/dev/null 2>&1
    gconftool-2 --type bool --set /apps/er/dr800plus/log_indexing "false"      >/dev/null 2>&1
    # create Backup of dr.ini
    cp -f /media/mmcblk0p1/System/dr.ini $ROOT/orig/dr.pre-dr800+.ini
    # and save current settings to disk
    /usr/bin/erconftool -e /apps/er/dr800plus >/dev/null 2>&1
}

remove_schema () {
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-uninstall-rule /etc/gconf/schemas/dr800+.schemas    >/dev/null 2>&1
    gconftool-2 --recursive-unset /apps/er/dr800plus/show_taskbar              >/dev/null 2>&1
    gconftool-2 --recursive-unset /schemas/apps/er/dr800plus/show_taskbar      >/dev/null 2>&1
    gconftool-2 --recursive-unset /apps/er/dr800plus/num_recent_items          >/dev/null 2>&1
    gconftool-2 --recursive-unset /schemas/apps/er/dr800plus/num_recent_items  >/dev/null 2>&1
    gconftool-2 --recursive-unset /apps/er/dr800plus/disable_indexing          >/dev/null 2>&1
    gconftool-2 --recursive-unset /schemas/apps/er/dr800plus/disable_indexing  >/dev/null 2>&1
    gconftool-2 --recursive-unset /apps/er/dr800plus/log_indexing              >/dev/null 2>&1
    gconftool-2 --recursive-unset /schemas/apps/er/dr800plus/log_indexing      >/dev/null 2>&1
    rm /etc/gconf/schemas/dr800+.schemas >/dev/null 2>&1
}


######################################################################
##### main actions
install () {
    if [ -s $ROOT/new/progs/uds.dr1000 ]; then # install only if nonzero uds.dr1000 file
        # first backup original programs, only if they don't exist
        if [ ! -f $ROOT/orig/progs/ctb ]; then
            backup_orig_firmware
        fi
        # migrate thumbs
        $ROOT/installfiles/migrate-thumbs --db2fs -q
        if [ $? -ne 0 ] ; then
            echo
            echo "Can't migrate thumbnails from global.db to file system"
        else
            # copy new files
            install_dr800plus
            install_schema
            # store "package is installed"
            touch $ROOT/dr800+.installed
        fi
    else
        echo "uds.dr1000 is not a valid file. Can't install DR800+"
    fi
}


restore () {
    if [ -f $ROOT/orig/progs/ctb ]; then
        # migrate thumbs
        $ROOT/installfiles/migrate-thumbs --fs2db -q
        if [ $? -ne 0 ] ; then
            echo
            echo "Can't migrate thumbnails from file system to global.db"
        else
            restore_orig_firmware
            remove_schema
            rm $ROOT/dr800+.installed >/dev/null 2>&1
        fi
    else
        echo "Can't find backup to restore"
    fi
}


backup () {
    if [ -f $ROOT/orig/progs/ctb ]; then
        echo "Backup already exists. Won't overwrite"
    else
        backup_orig_firmware
    fi
}


show_error () {
    echo "Error: $1"
    echo "Use: $0 { --install | --restore | --backup }"
}


######################################################################
##### Main: parse arguments and launch actions
if [ $# -ne 1 ]; then
    show_error "invalid number of arguments: $*"
else
    case "$1" in
        --install) install;;
        --restore) restore;;
        --backup) backup;;
        *) show_error "invalid argument: $1";;
    esac
fi


######################################################################
