#include "config.h"
#include "log.h"
#include "index_db.h"
#include <sys/time.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
int ermetadb_global_select_private (erMetadb thiz, const gchar* sql, metadata_table **values_tbl);

int main (int argc, char *argv[])
{
    gtk_init(&argc, &argv);
    g_type_init();

    if (argc != 2 && argc != 3) {
        fprintf(stderr, "Usage: %s [dir]  [1|2|3|4]\n",argv[0]);
        fprintf(stderr, "\t1 - patch generic data base\n");
        fprintf(stderr, "\t2 - patch settings data base\n");
        fprintf(stderr, "\t3 - undo generic data base\n");
        fprintf(stderr, "\t4 - undo setingd data base\n");
        return 1;
    }
    gint option = (argc == 3) ? *argv[2] - '0' : 1;

    ipc_set_services(NULL, NULL);

    printf("%s: indexing %s  %d\n", argv[0], argv[1], option);
    u_int64_t start = getCurrentTime();

    // check if dir exists and is dir
    struct stat statbuf;
    int res = stat(argv[1], &statbuf);
    if (res == -1 || !S_ISDIR(statbuf.st_mode)) {
        ERRORPRINTF("%s: directory '%s' doesn't exist or is not a dir\n", argv[0], argv[1]);
        return -1;
    }

    db_state_t db_state;
    if (db_open_global(&db_state, argv[1]) != ER_OK)
    {
      ERRORPRINTF("Failed to open global db");
      return -1;
    }
    // create indexes
    switch(option){
      default: 
      case 1:
        // install regular database creation
        ermetadb_global_select_private (db_state.mdb, "UPDATE OR ROLLBACK file_metadata SET sort_priority=5 WHERE is_directory=1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_title_i1 ON file_metadata(tag,sort_priority ASC,title COLLATE IREX_CASE_INSENSITIVE ASC,filename COLLATE IREX_CASE_INSENSITIVE ASC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_fname_i1 ON file_metadata(tag,sort_priority ASC,filename COLLATE IREX_CASE_INSENSITIVE ASC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_author_i1 on file_metadata(tag,sort_priority ASC,author COLLATE IREX_CASE_INSENSITIVE ASC, title COLLATE IREX_CASE_INSENSITIVE ASC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_file_type_i1 on file_metadata(tag,sort_priority ASC,file_type ASC, title COLLATE IREX_CASE_INSENSITIVE ASC,filename COLLATE IREX_CASE_INSENSITIVE ASC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_file_size_i1 on file_metadata(tag,sort_priority ASC,file_size DESC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_file_time_added_i1 on file_metadata(tag,sort_priority ASC,file_time_added DESC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_file_time_latest_i1 on file_metadata(tag,sort_priority ASC,file_time_lastread DESC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_directory_i1 on file_metadata(directory_path);",NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS search_i1 on file_metadata(filename,title,author,tag);",NULL);
        break;
      case 2:
        // install settings data base
        ermetadb_global_select_private (db_state.mdb, "UPDATE OR ROLLBACK file_metadata SET sort_priority = 100 - sort_priority;", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_title_i1 ON file_metadata(tag,sort_priority ASC,title COLLATE IREX_CASE_INSENSITIVE ASC,filename COLLATE IREX_CASE_INSENSITIVE ASC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_fname_i1 ON file_metadata(tag,sort_priority ASC,filename COLLATE IREX_CASE_INSENSITIVE ASC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_author_i1 on file_metadata(tag,sort_priority ASC,author COLLATE IREX_CASE_INSENSITIVE ASC, title COLLATE IREX_CASE_INSENSITIVE ASC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_file_type_i1 on file_metadata(tag,sort_priority ASC,file_type ASC, title COLLATE IREX_CASE_INSENSITIVE ASC,filename COLLATE IREX_CASE_INSENSITIVE ASC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_file_size_i1 on file_metadata(tag,sort_priority ASC,file_size DESC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_file_time_added_i1 on file_metadata(tag,sort_priority ASC,file_time_added DESC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_file_time_latest_i1 on file_metadata(tag,sort_priority ASC,file_time_lastread DESC);", NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS sort_directory_i1 on file_metadata(directory_path);",NULL);
        ermetadb_global_select_private (db_state.mdb, "CREATE INDEX IF NOT EXISTS search_i1 on file_metadata(filename,title,author,tag);",NULL);
        break;
      case 3:
        // uninstall regular global.db
        ermetadb_global_select_private (db_state.mdb, "UPDATE OR ROLLBACK file_metadata SET sort_priority=20 WHERE is_directory=1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_title_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_fname_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_author_i1", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_file_type_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_file_size_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_file_time_added_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_file_time_latest_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_directory_i1;",NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS search_i1;",NULL);
        break;
      case 4:
        // uninstall settings global.db
        ermetadb_global_select_private (db_state.mdb, "UPDATE OR ROLLBACK file_metadata SET sort_priority=100-sort_priority;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_title_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_fname_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_author_i1", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_file_type_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_file_size_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_file_time_added_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_file_time_latest_i1;", NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS sort_directory_i1;",NULL);
        ermetadb_global_select_private (db_state.mdb, "DROP INDEX IF EXISTS search_i1;",NULL);
        break;
    }

    db_close(&db_state);

    u_int64_t end = getCurrentTime();
    u_int64_t diff = end - start;
    printf("%s: indexing took %lld ms\n", argv[0], diff / 1000);

    ipc_unset_services();
    return 0;
}
