#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_ctb800sg
INSTALLERDIR=/media/mmcblk0p1/Programs/Install 
ZENITY=/media/mmcblk0p1/Programs/_base/bin/zenity 


#backup all data
backup_original_files () { 
    if [ ! -e $THISDIR/backup ] 
    then 
       /bin/mkdir -p $THISDIR/backup
       /bin/cp /usr/bin/ctb    $THISDIR/backup/ctb
       /bin/cp /usr/lib/libermetadb.so.0.0.0    $THISDIR/backup/libermetadb.so.0.0.0
       /bin/cp /etc/global.db    $THISDIR/backup/global.db
       /bin/cp /usr/share/ctb/settings/global.db    $THISDIR/backup/global_settings.db
    fi
}

#install all new files
install_new_files () { 
   /bin/chmod a+x $THISDIR/ctb
   /bin/chmod a-x $THISDIR/global.db
   /bin/chmod a+x $THISDIR/reindex

   /bin/cp -f $THISDIR/ctb /usr/bin/ctb
   /bin/cp -f $THISDIR/libermetadb.so.0.0.0 /usr/lib/libermetadb.so.0.0.0
   /bin/cp -f $THISDIR/global.db /etc/global.db

   # reindex old books database
   $THISDIR/reindex /media/mmcblk0p1/ 1
   $THISDIR/reindex /media/mmcblk0p1/System/Shortcuts/ 1
   $THISDIR/reindex /usr/share/ctb/settings/ 2
}

restore_original_files () {
    # Restore the original program(s)
    if [ -e $THISDIR/backup ]
    then
       /bin/cp -f $THISDIR/backup/ctb  /usr/bin/ctb
       /bin/cp -f $THISDIR/backup/libermetadb.so.0.0.0  /usr/lib/libermetadb.so.0.0.0
       /bin/cp -f $THISDIR/backup/global.db  /etc/global.db
       /bin/cp -f $THISDIR/backup/global_settings.db  /usr/share/ctb/settings/global.db

       #remove new indexes
       $THISDIR/reindex /media/mmcblk0p1/ 3
       $THISDIR/reindex /media/mmcblk0p1/System/Shortcuts/ 3
    fi
} 


# TODO: Check if required components (zenity/mtag) are installed

if [ -f $THISDIR/backup ]; then
    $ZENITY --question --title "Enhanced file manager" --text "<b>De-install</b>\n\nDo you want to restore original IREX programs?"
    if [ $? -eq 0 ]; then
        echo "Restoring original files"
        restore_original_files

        $ZENITY --info --title "Enhanced file manager" --text "<b>New version is removed</b>\n\nPress ok to reboot"
        /sbin/reboot
        sleep 31
    fi
fi

$ZENITY --question --title "Enhanced file manager" --text "<b>Upgrade</b>\n\nDo you want to install Enhanced file manager?"
if [ $? -eq 0 ]; then
    # We will only come here if de-install was not choosen!!

    echo "Backingup original application and libraries"
    backup_original_files

    echo "Installing new application"
    install_new_files

    $ZENITY --info --title "Enhanced file manager" --text "<b>Done</b>\n\nPress ok to reboot"
    /sbin/reboot
    sleep 31
fi 


