#!/usr/bin/env python

__license__   = 'GPL v3'
__copyright__ = '2011, BurbleBurble <mobireads_forum> <NAMLEHMIARFE>'

import sys
import os
import os.path
from PyQt4 import QtCore, QtGui, QtWebKit, Qt
from lxml import etree
import lxml.html

try:
    #calibre environment
    from calibre_plugins.ebook_cleaner import epub
except ImportError:
    #python environment
    import epub

class OpenWizard(QtGui.QWizard):
    def __init__(self, text, path_to_epub, configuration, parent=None):
        #self
        super(OpenWizard, self).__init__(parent)
        self.setWindowTitle("Clean and Open")
        self.setLayout(QtGui.QGridLayout())
        #epub
        self.epub_object = None
        self.path_to_epub = path_to_epub
        #config
        self.configuration = configuration
        #pages
        self.addPage(OpenIntroPage())
        #self.addPage(ClassInfoPage())

        #self.setPixmap(QtGui.QWizard.BannerPixmap,
        #        QtGui.QPixmap(':/images/banner.png'))
        #self.setPixmap(QtGui.QWizard.BackgroundPixmap,
        #        QtGui.QPixmap(':/images/background.png'))

        #


        #text
        self.text = text


    def accept(self):
        #read
        print('[LOG]Reading...')
        epub_reader = epub.EpubReader()
        self.epub_object = epub_reader.read(self.path_to_epub, self.configuration.tempdir)
        #clean
        print('[LOG]Cleaning...')
        cleaner = epub.EpubXhtmlXmlCleaner()
        cleaner.clean(self.epub_object, self.configuration.tags, self.configuration.style_names, self.configuration.style_values)
        #open
        print('[LOG]Opening...')
        url = self.epub_object.getXhtmlXml()[0]
        self.text.setUrl(QtCore.QUrl(url))

        super(OpenWizard, self).accept()

class OpenIntroPage(QtGui.QWizardPage):
    def __init__(self, parent=None):
        super(OpenIntroPage, self).__init__(parent)

        self.setTitle("Introduction")
        #self.setPixmap(QtGui.QWizard.WatermarkPixmap,
        #        QtGui.QPixmap(':/images/watermark1.png'))

        label = QtGui.QLabel("This wizard will generate a skeleton C++ class "
                "definition, including a few functions. You simply need to "
                "specify the class name and set a few options to produce a "
                "header file and an implementation file for your new C++ "
                "class.")
        label.setWordWrap(True)

        layout = QtGui.QVBoxLayout()
        layout.addWidget(label)
        self.setLayout(layout)


def main():
    pass

if __name__ == '__main__':
    main()
