#!/usr/bin/env python

from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, BurbleBurble <mobireads forum>'

from calibre.gui2 import error_dialog
from calibre.gui2.actions import InterfaceAction
from calibre_plugins.ebook_cleaner.main import Main
import os.path

class EbookCleanerPlugin(InterfaceAction):

    name = 'Ebook Cleaner'
    action_spec = ('Ebook Cleaner', None,
            'Run Ebook Cleaner', None)
    dont_add_to = frozenset(['menubar-device', 'toolbar-device', 'context-menu-device'])

    def genesis(self):
        # This method is called once per plugin, do initial setup here
        # The get_icons function is a builtin function defined for all your
        # plugin code. It loads icons from the plugin zip file. It returns
        # QIcon objects, if you want the actual data, use the analogous
        # get_resources builtin function.        #
        # Note that if you are loading more than one icon, for performance, you
        # should pass a list of names to get_icons. In this case, get_icons
        # will return a dictionary mapping names to QIcons. Names that
        # are not found in the zip file will result in null QIcons.
        icon = get_icons('icons/icon.png')

        # The qaction is automatically created from the action_spec defined
        # above
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.show_dialog)

    def get_epub_path(self):
        row = self.gui.library_view.currentIndex()
        if not row.isValid():
            return error_dialog(self.gui, _('Cannot tweak ePub'),
                    _('No book selected'), show=True)

        # Confirm 'EPUB' in formats
        book_id = self.gui.library_view.model().id(row)
        try:
            path_to_epub = self.gui.library_view.model().db.format_abspath(
                    book_id, 'EPUB', index_is_id=True)
        except:
            path_to_epub = None

        if not path_to_epub:
            return error_dialog(self.gui, _('Cannot tweak ePub'),
                    _('No ePub available. First convert the book to ePub.'),
                    show=True)

        return path_to_epub

    def show_dialog(self):
        # The base plugin object defined in __init__.py
        base_plugin_object = self.interface_action_base_plugin
        # Show the config dialog
        # The config dialog can also be shown from within
        # Preferences->Plugins, which is why the do_user_config
        # method is defined on the base plugin class
        '''Note implemented in this plugin
        do_user_config = base_plugin_object.do_user_config
        '''

        # self.gui is the main calibre GUI. It acts as the gateway to access
        # all the elements of the calibre user interface, it should also be the
        # parent of the dialog
        path_to_epub=self.get_epub_path()
        dialog = Main(parent=self.gui, path_to_epub=path_to_epub)
        dialog.show()



    def apply_settings(self):
        from calibre_plugins.ebook_cleaner.config import prefs
        # In an actual non trivial plugin, you would probably need to
        # do something based on the settings in prefs
        prefs

