#!/bin/sh

ROOT=/media/mmcblk0p1/Programs/_fbreader


######################################################################
#####
install_schema () {
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    cp -f $ROOT/installfiles/fbreader.schemas /etc/gconf/schemas/fbreader.schemas
    gconftool-2 --makefile-install-rule /etc/gconf/schemas/fbreader.schemas  >/dev/null 2>&1
    cp -f $ROOT/installfiles/icon-fbreader-medium.png /usr/share/ctb/icon-fbreader-medium.png
    cp -f $ROOT/installfiles/icon-fbreader-mini.png   /usr/share/ctb/icon-fbreader-mini.png
    cp -f $ROOT/installfiles/icon-fbreader-small.png  /usr/share/ctb/icon-fbreader-small.png
}

remove_schema () {
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-uninstall-rule /etc/gconf/schemas/fbreader.schemas      >/dev/null 2>&1
    gconftool-2 --recursive-unset /apps/er/sys/ctb/filetypes/doc-fbreader          >/dev/null 2>&1
    gconftool-2 --recursive-unset /schemas/apps/er/sys/ctb/filetypes/doc-fbreader  >/dev/null 2>&1
    rm -f /etc/gconf/schemas/fbreader.schemas      >/dev/null 2>&1
    rm -f /usr/share/ctb/icon-fbreader-medium.png  >/dev/null 2>&1
    rm -f /usr/share/ctb/icon-fbreader-mini.png    >/dev/null 2>&1
    rm -f /usr/share/ctb/icon-fbreader-small.png   >/dev/null 2>&1
}


######################################################################
##### main actions
install1 () {
    install_schema
    cp -f $ROOT/share/FBReader/default/yes_toolbar.xml $ROOT/share/FBReader/default/toolbar.xml
}


install2 () {
    install_schema
    cp -f $ROOT/share/FBReader/default/fullscreen_toolbar.xml $ROOT/share/FBReader/default/toolbar.xml
}


restore () {
    remove_schema
    cp -f $ROOT/share/FBReader/default/fullscreen_toolbar.xml $ROOT/share/FBReader/default/toolbar.xml
}


show_error () {
    echo "Error: $1"
    echo "Use: $0 { --install1 | --install2 | --restore }"
}


######################################################################
##### Main: parse arguments and launch actions
if [ $# -ne 1 ]; then
    show_error "invalid number of arguments: $*"
else
    case "$1" in
        --install1) install1;;
        --install2) install2;;
        --restore) restore;;
        *) show_error "invalid argument: $1";;
    esac
fi


######################################################################
