/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QSCREENEINKFB_QWS_H
#define QSCREENEINKFB_QWS_H

#include <QScreen>
#include <QTimer>
#include <QRect>
#include <QObject>

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

QT_MODULE(Gui)

#ifndef QT_NO_QWS_EINKFB

class QEInkFbScreenPrivate : public QObject
{
Q_OBJECT

public:
    QEInkFbScreenPrivate();
    ~QEInkFbScreenPrivate();

    void setDirty(const QRect&);

    int fd;
    int startupw;
    int startuph;
    int startupd;

    QString displaySpec;

    int updateMode;
    int updateWaitTime;

public slots:
    void doUpdate();

private:
    QTimer *lazyTimer;
    QRect *dirtyRect;
};


class Q_GUI_EXPORT QEInkFbScreen : public QScreen
{
public:
    explicit QEInkFbScreen(int display_id);
    virtual ~QEInkFbScreen();

    virtual bool initDevice();
    virtual bool connect(const QString &displaySpec);

    virtual void disconnect();
    virtual void shutdownDevice();
    virtual void setMode(int,int,int);
    virtual void setDirty(const QRect&);

    virtual void solidFill(const QColor &color, const QRegion &region);
    virtual void blit(const QImage &img, const QPoint &topLeft, const QRegion &region);

    enum updateMode {updateModePartial=0, updateModeFull=1};

    void setUpdateMode(int mode);

private:

    void setPixelFormat();
    
    QEInkFbScreenPrivate *d_ptr;
};

#endif // QT_NO_QWS_EINKFB

QT_END_NAMESPACE

QT_END_HEADER

#endif // QSCREENEINKFB_QWS_H
