#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, Kovid Goyal <kovid@kovidgoyal.net>'
__docformat__ = 'restructuredtext en'

if False:
    # This is here to keep my python error checker from complaining about
    # the builtin functions that will be defined by the plugin loading system
    # You do not need this code in your plugins
    get_icons = get_resources = None

from PyQt4.Qt import QDialog, QVBoxLayout, QPushButton, QMessageBox, QLabel

from PyQt4.Qt import Qt, QMenu, QModelIndex, QTimer

from calibre_plugins.add_date.config import prefs

from calibre.gui2 import error_dialog, Dispatcher, question_dialog

class DemoDialog(QDialog):

    def __init__(self, gui, icon, do_user_config):
        QDialog.__init__(self, gui)
        self.gui = gui
        self.do_user_config = do_user_config

        # The current database shown in the GUI
        # db is an instance of the class LibraryDatabase2 from database.py
        # This class has many, many methods that allow you to do a lot of
        # things.
        self.db = gui.current_db

        self.l = QVBoxLayout()
        self.setLayout(self.l)

        self.setWindowTitle('Add Date Plugin')
        self.setWindowIcon(icon)

        self.about_button = QPushButton('About', self)
        self.about_button.clicked.connect(self.about)
        self.l.addWidget(self.about_button)

        self.view_button = QPushButton(
            'Add date to title of selected entry.', self)
        self.view_button.clicked.connect(self.view)
        self.l.addWidget(self.view_button)

        self.resize(self.sizeHint())

    def about(self):
        
        # Get the about text from a file inside the plugin zip file
        # The get_resources function is a builtin function defined for
        # all your plugin code. It loads files from the plugin zip
        # file. It returns the bytes from the specified file.
        #
        # Note that if you are loading more than one file, for
        # performance, you should pass a list of names to
        # get_resources. In this case, get_resources will return a
        # dictionary mapping names to bytes. Names that are not found
        # in the zip file will not be in the returned dictionary.
        text = get_resources('about.txt')
        QMessageBox.about(self, 'About the Add Date Plugin',
                text.decode('utf-8'))

    def view(self):
        rows = self.gui.library_view.selectionModel().selectedRows()
        previous = self.gui.library_view.currentIndex()

        if not rows or len(rows) != 1:
            d = error_dialog(self.gui, _('Cannot edit metadata'),
                             _('Please select exactly one row.'))
            d.exec_()
            return

        row_list = [r.row() for r in rows]
        current_row = 0

        if len(row_list) == 1:
            cr = row_list[0]
            row_list = \
                list(range(
                     self.gui.library_view.model().rowCount(QModelIndex())))
            current_row = row_list.index(cr)

        # Code added by Rozen

        r_db = self.gui.library_view.model().db
        r_id = r_db.id(current_row)
        #r_title = r_db.title(current_row)
        #r_timestamp = r_db.timestamp(current_row)
        r_metadata = r_db.get_metadata(current_row)
        r_title = r_metadata.title
        metadata_timestamp = r_metadata.timestamp
        metadata_timestamp = metadata_timestamp.timetuple()

        import time
        date_addition = time.strftime("%a, %d %b %Y", metadata_timestamp)
        if r_title.find(date_addition) > -1:
            self.close()
            return
        new_title = r_title + ' [' + date_addition + ']'
        r_metadata.title = new_title

        r_db.set_metadata(r_id, r_metadata)
        #changed, rows_to_refresh = self.do_edit_metadata(row_list, current_row)
        changed = set([r_id])
        rows_to_refresh = set([r_id])

        m = self.gui.library_view.model()

        if rows_to_refresh:
            m.refresh_rows(rows_to_refresh)

        if changed:
            m.refresh_ids(list(changed))
            current = self.gui.library_view.currentIndex()
            if self.gui.cover_flow:
                self.gui.cover_flow.dataChanged()
            m.current_changed(current, previous)
            self.gui.tags_view.recount()

        self.close()


'''

config/calibre/plugins/edit_metadata.py  line 148.

run changes using commad  \'data-add\'

date-add ()
{
    unset CALIBRE_DEVELOP_FROM
    setenv CALIBRE_DEVELOP_FROM /home/rozen/cal/calibre/src
    zip -r /home/rozen/.config/calibre/plugins/Add\ Date\ Plugin.zip *;
    calibre-debug -g
}

setenv CALIBRE_DEVELOP_FROM /home/rozen/cal/calibre/src

'''

