#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, drMerry'
__docformat__ = 'restructuredtext en'

from PyQt4.Qt import QModelIndex, QProgressDialog, QString, QTimer
from calibre.gui2 import info_dialog
from calibre.utils.logging import GUILog

from calibre_plugins.epub_checker.dialogs import QualityProgressDialog, ResultsSummaryDialog

class BaseCheck(object):
    '''
    Base class for all Epub Checker implementations
    '''
    def __init__(self, gui):
        self.gui = gui
        self.log = GUILog()

    def perform_check(self, menu_key):
        '''
        Override this method to perform the appropriate check for the menu key given
        '''
        pass

    def get_book_ids(self, initial_search=''):
        if initial_search:
            self.gui.search.set_search_string(initial_search)
        else:
            self.gui.search.clear()
        model = self.gui.library_view.model()
        rows = xrange(model.rowCount(QModelIndex()))
        book_ids = map(model.id, rows)
        return book_ids

    def check_all_files(self, callback_fn, initial_search='', status_msg_type='books',
                        no_match_msg=None, show_matches=True, marked_text='true'):
        '''
        Does the Epub Checker check in a threaded fashion with progress dialog
        '''
        book_ids = self.get_book_ids(initial_search)
        d = QualityProgressDialog(self.gui, book_ids, callback_fn, self.gui.current_db,
                                  status_msg_type)
        if not d.wasCanceled():
            if show_matches:
                if len(d.result_ids) > 0:
                    self.show_invalid_rows(d.result_ids, marked_text)
                    if self.log.plain_text:
                        sd = ResultsSummaryDialog(self.gui, 'Epub Checker',
                                                 '%d matches found, see log for errors'%len(d.result_ids),
                                                 self.log)
                        sd.exec_()
                if no_match_msg:
                    msg = 'Checked %d books, found %d matches' %(d.total_count, len(d.result_ids))
                    self.gui.status_bar.showMessage(msg)
                    if len(d.result_ids) == 0:
                        sd = ResultsSummaryDialog(self.gui, 'No Matches', no_match_msg, self.log)
                        sd.exec_()
        return d.total_count, d.result_ids, d.wasCanceled()

    def show_invalid_rows(self, result_ids, marked_text='true'):
        marked_ids = dict.fromkeys(result_ids, marked_text)
        self.gui.library_view.model().db.set_marked_ids(marked_ids)
        self.gui.search.set_search_string('marked:%s' % marked_text)