#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, drMerry'
__docformat__ = 'restructuredtext en'

import os
from PIL import Image
from calibre.gui2 import info_dialog, error_dialog

from calibre_plugins.epub_checker.check_base import BaseCheck
from calibre_plugins.epub_checker.dialogs import CoverOptionsDialog, ResultsSummaryDialog


class CommonChecks(BaseCheck):
    '''
    All checks related to working with file sizes.
    '''
    def perform_check(self, menu_key):
        if menu_key == 'create_cache':
            self.create_cache()
        else:
            return error_dialog(self.gui, _('Epub Checker create cache'),
                                _('Unknown menu key for %s of \'%s\'')%('Common Checks', menu_key),
                                show=True, show_copy_button=False)

    def create_cache(self):
        return error_dialog(self.gui, _('Epub Checker create cache'),
                                _('This function is not yet implemented'),
                                show=True, show_copy_button=False)

                                