#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_mackxpatch
INSTALLERDIR=/media/mmcblk0p1/Programs/Install
ZENITY=/media/mmcblk0p1/Programs/_base/bin/zenity
MTAG=/media/mmcblk0p1/Programs/_mackxpatch/bin/mtag

cd $THISDIR

$ZENITY --question --title "MackxPatch View" --text "<b>Add View</b>\n\nDo you want to add the AnyFolder View?"
if [ $? -eq 0 ]; then

    # Adapt gconf to enable the new views
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`

    # AnyView View
    /bin/cp -f ./schemas/anyfolder.schemas /etc/gconf/schemas/anyfolder.schemas
    gconftool-2 --makefile-install-rule /etc/gconf/schemas/anyfolder.schemas
    # copy the icons
    # /bin/cp -f ./icons/icon-download-medium.png /usr/share/ctb/icon-download-medium.png
    # /bin/cp -f ./icons/icon-download-small.png /usr/share/ctb/icon-download-small.png
    # /bin/chmod a-x /usr/share/ctb/icon-download-*

    # Enable the appropriate views
    gconftool-2 --type string --set /apps/er/patch/ctb/views/anyfolder/mode "enabled"

    # Create Backup of dr.ini
    /bin/cp -f /media/mmcblk0p1/System/dr.ini /media/mmcblk0p1/System/dr.patch.ini
    # and save the (just modified) settings to disk
    /usr/bin/erconftool -e /apps/er

    # For the new version to be used, a reset is needed
    # /sbin/reboot
    # sleep 31
fi