# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

__license__   = 'GPL v3'
__copyright__ = '2011, meme'
__docformat__ = 'restructuredtext en'

#####################################################################
# Save function shared by Create and Edit
#####################################################################

import calibre_plugins.kindle_collections.messages as msg
import calibre_plugins.kindle_collections.config as cfg
import calibre_plugins.kindle_collections.kindle_books as kindle_books
import calibre_plugins.kindle_collections.kindle_device as kindle_device
import calibre_plugins.kindle_collections.kindle_collections as kindle_collections
from calibre_plugins.kindle_collections.utilities import debug_print, wording

status = None

#####################################################################

def save_kindle_collections(compare):
    try:
        kindle_device.kdevice.save_collections(kindle_collections.kc.get_raw_collections(), compare)
    except ValueError as error:
        msg.message.error(str(error))
    else:
        if kindle_collections.kc.get_len():
            msg.message.info('<P>%s saved to the Kindle.' % wording('Collection', 'Collections', kindle_collections.kc.get_len()))
        else:
            msg.message.info('Collection file removed from the Kindle since there were no collections to save.')

        msg.message.info('%s' % get_summary())

        save_fast_reboot()

def save_fast_reboot():
        if cfg.config_settings and 'fast_reboot' in cfg.config_settings and cfg.config_settings['fast_reboot'] and kindle_device.kdevice.get_kindle_hack_reboot_trigger_file():
            kindle_device.kdevice.create_kindle_hack_reboot_trigger_file()
            msg.message.info('<P>Eject and unplug the Kindle - it will automatically reboot and load your changes without restarting the Kindle.')
        else:
            msg.message.info('<P>Eject and Restart the Kindle to load your changes.')

def get_summary():
    collections = kindle_collections.kc.get_len()
    books = len(kindle_books.kbooks.code_paths)
    summary = '\n%d %s' % (collections, wording('collection', 'collections',collections))
    c = kindle_books.kbooks.counts['books']
    if c > 0:
        summary += ', %d %s' % (c, wording('book', 'books', c))
    c = kindle_books.kbooks.counts['newspapers']
    if c > 0:
        summary += ', %d %s' % (c, wording('newspaper', 'newspapers', c))
    c = kindle_books.kbooks.counts['magazines']
    if c > 0:
        summary += ', %d %s' % (c, wording('magazine', 'magazines', c))
    c = kindle_books.kbooks.counts['feeds']
    if c > 0:
        summary += ', %d %s' % (c, wording('news feed', 'news feeds', c))
    summary += ' found on the Kindle.'
    return summary

