# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

__license__   = 'GPL v3'
__copyright__ = '2011, meme'
__docformat__ = 'restructuredtext en'

#####################################################################
# Messages
#####################################################################

import re, time
from PyQt4.Qt import QFont

from calibre.gui2 import error_dialog, info_dialog

from calibre_plugins.kindle_collections.utilities import debug_print, wording
from calibre_plugins.kindle_collections.__init__ import PLUGIN_NAME

message = None

#####################################################################

def init(parent):
    global message
    message = Messages(parent)

class Messages():
    def __init__(self, parent):
        self.gui = parent.gui
        self.clear()

    def clear(self):
        self.header_str = ''
        self.error_str = ''
        self.warning_str = ''
        self.info_str = ''
        self.report_str = ''
        self.warning_count = 0

    def error(self, text):
        self.error_str += text + '<P>'
        debug_print(text)

    def info(self, text):
        self.info_str += text + '<P>'
        debug_print(text)

    def warning(self, text, count=True):
        self.warning_str += text + '\n'
        if count:
            self.warning_count += 1
        debug_print(text)

    def header(self, text):
        self.header_str += text + '\n'
        debug_print(text)

    def report(self, text):
        try:
            text = text.decode('utf-8', 'replace')
        except:
            pass
        self.report_str += text + '\n'
        debug_print(text)

    def get_all(self):
        if self.warning_str:
            self.report_str = wording('Warning:', 'Warnings:', self.warning_count) + '\n' + self.warning_str + '\n' + self.report_str 

        if self.report_str:
            if self.warning_str:
                self.info_str += '<P>%d warning %s.' % (self.warning_count, wording('message', 'messages', self.warning_count))

        if self.header_str:
            self.report_str = self.header_str + self.report_str

        return (self.info_str, self.error_str, self.report_str)

    # Display all error, warning, info messages at same time
    def display(self):
        from calibre.constants import iswindows

        (info, error, detail) = message.get_all()

        if error:
            error_dialog(self.gui, _(PLUGIN_NAME), _(error), '', show=True)
        elif info:
            dialog = info_dialog(self.gui, _(PLUGIN_NAME), _(info), detail, show=False)
            font = QFont()
            if iswindows:
                font.setFamily('Courier')
                font.setFixedPitch(True)
            else:
                font.setFamily('monospace')
            dialog.det_msg.setFont(font)
            dialog.det_msg.setMinimumSize(1000,700)
            dialog.exec_()
        self.clear()

