# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

__license__   = 'GPL v3'
__copyright__ = '2011, meme'
__docformat__ = 'restructuredtext en'

#####################################################################
# Restore collection file on Kindle
#####################################################################

from calibre.gui2 import question_dialog

import calibre_plugins.kindle_collections.messages as msg
import calibre_plugins.kindle_collections.config as cfg
import calibre_plugins.kindle_collections.calibre_info as calibre_info
import calibre_plugins.kindle_collections.kindle_device as kindle_device
from calibre_plugins.kindle_collections.utilities import debug_print
from calibre_plugins.kindle_collections.__init__ import PLUGIN_NAME

#####################################################################

# Menu item Restore
def run(parent):
    debug_print('BEGIN Restore collections file')
    gui = parent.gui

    if not cfg.init(parent):
        msg.message.display()
        debug_print('END Restore collections File - initialization failed')
        return False

    calibre_info.ci.load_column_book_info()
    kindle_device.init(calibre_info.ci.device_path)

    if question_dialog(gui, _('Restore ' + PLUGIN_NAME), '<P>'+
            'Are you sure you want to restore the previous Collections file saved on the Kindle?', show_copy_button=False):
        try:
            kindle_device.kdevice.restore_collections()
        except ValueError as e:
            msg.message.error(str(e))
        else:
            msg.message.info('Collections restored.')
        msg.message.display()

    debug_print('END Restore collections File')
