/**********************************************************************************************
    Copyright (C) 2010 Stephan Olbrich reader42@gmx.de
    Modifications and Adaptations - Copyright (C) 2011 dimpflmoser

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**********************************************************************************************/
//
// tazGrabber MainView.h
//

#ifndef MAINVIEW_H
#define MAINVIEW_H

#include <deque>
#include <inkview.h>

#define CFG_FILE "/mnt/ext1/games/tazGrabber.cfg"
//#define WGET "/mnt/ext1/games/wget"
#define WGET "/bin/wget"
#define WGET_LOG "/mnt/ext1/games/wget.log"
#define TAZ_URL_BASE "http://%s:%s@dl.taz.de/taz/abo/get.php?f=taz_%2d_%02d_%02d.epub"

#define STATUS_MSG "tazGrabber V0.1 - based on code by reader42, inspired by Hildegunst"
const int default_x_size = 200;
const int default_y_size = 75;

const int actionGetTazToday = 1;
const int actionGetTazTomorrow = 2;
const int action_start_net = 3;
const int action_stop_net = 4;
const int action_quit = 5;

class Label
{
  public:
    Label(char * text, int x, int y, int sx = default_x_size, int sy = default_y_size);
    ~Label();
    void setLabel(char* text);
    void paint();
    
  private:
    int pos_x;
    int pos_y;
    int size_x;
    int size_y;
    char * label;
};

class Button
{
  public:
    Button(char * text, int action, int x, int y, 
	   int sx = default_x_size, int sy = default_y_size, char * busyText = NULL, unsigned char isBusy = 0);
    ~Button();
    void paint();
    int hit(int x, int y);
    bool operator==(const Button &other);
    bool operator!=(const Button &other);
    int button_action;
    void highlight();
    void setBusy(unsigned char isBusy);
    
  private:
    int pos_x;
    int pos_y;
    int size_x;
    int size_y;
    char * label;
    unsigned char isBusy;
    char * busyLabel;
};


class MainView
{
  public:
    MainView();
    ~MainView();
    void repaint();
    int hit(int x, int y);
    int GetTazToday();
    //int GetTazYesterday();
    int GetTazTomorrow();
    int NetworkConnect();
    int NetworkDisconnect();
    void highlight(int action);
    
  private:
    char * defaultNetConnection();

    std::deque<Button> buttons;
    Label *statusBar;
    ifont * font;

    char TAZ_TARGET_DIR[255];
    char TAZ_USER[12];
    char TAZ_PASSWD[12];
};


#endif
