/**********************************************************************************************
    Copyright (C) 2010 Stephan Olbrich reader42@gmx.de
    Modifications and Adaptations - Copyright (C) 2011 dimpflmoser

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**********************************************************************************************/
//
// tazGrabber MainView.cpp
//

#include <inkview.h>

#include "MainView.h"
#include <stdio.h>
#include <time.h>

extern FILE * LogFile;

Button::Button(char * text, int action, int x, int y, int sx, int sy, char * busyText, unsigned char isBusy)
{
  pos_x = x;
  pos_y = y;
  size_x = sx;
  size_y = sy;
  label = text;
  button_action = action;
  this->isBusy = isBusy;
  busyLabel = busyText;
  return;
}

Button::~Button()
{

}

void Button::paint()
{
  fprintf(LogFile, "Button->paint() %s\n", label);
  DrawRect(pos_x, pos_y, size_x, size_y, BLACK);
  if(isBusy)
    DrawTextRect(pos_x, pos_y, size_x, size_y, busyLabel, ALIGN_CENTER | VALIGN_MIDDLE);
  else
    DrawTextRect(pos_x, pos_y, size_x, size_y, label, ALIGN_CENTER | VALIGN_MIDDLE);
  return;
}

int Button::hit(int x, int y)
{
  fprintf(LogFile, "Button->hit() %s\n", label);
  if ( (x > pos_x) && (x < (pos_x + size_x)) && (y > pos_y) && (y < (pos_y + size_y)) )
  {
    fprintf(LogFile, "Button hit! %s\n", label);
    return button_action;
  }
  else
    return 0;
}

bool Button::operator==(const Button& other)
{
  if (button_action == other.button_action)
    return true;
  else
    return false;
}

bool Button::operator!=(const Button& other)
{
  return !(*this == other);
}

Label::Label(char* text, int x, int y, int sx, int sy)
{
  pos_x = x;
  pos_y = y;
  size_x = sx;
  size_y = sy;
  label = text;
  return;
}

Label::~Label()
{

}

void Label::setLabel(char* text){
  label = text;
  this->paint();
  PartialUpdateBW(pos_x, pos_y, size_x, size_y);
}

void Label::paint()
{
  fprintf(LogFile, "Label->paint() %s\n", label);
  FillArea(pos_x, pos_y, size_x, size_y, WHITE);
  DrawRect(pos_x, pos_y, size_x, size_y, BLACK);
  DrawTextRect(pos_x, pos_y, size_x, size_y, label, ALIGN_CENTER | VALIGN_MIDDLE);
  return;
}

MainView::MainView()
{
  const int frame = 20;
  int w = (ScreenWidth() - 3*frame)/2;
  int h = (ScreenHeight() - 4*frame)/3;
  h = (h < default_y_size ? h : default_y_size);
  
  Button button1("taz von Heute", actionGetTazToday, frame, frame, w, h);
  Button button2("taz von Morgen", actionGetTazTomorrow, 2*frame + w, frame, w, h);
  Button button3("Start Network", action_start_net, frame, 2*frame + h, w, h);
  Button button4("Stop Network", action_stop_net, 2*frame + w, 2*frame + h, w, h);
  Button button5("Quit", action_quit, (3*frame + w)/2, 3*frame + 2*h, w, h);
  buttons.push_front(button1);
  buttons.push_front(button2);
  buttons.push_front(button3);
  buttons.push_front(button4);
  buttons.push_front(button5);
  
  statusBar   = new Label(STATUS_MSG, frame, ScreenHeight() - 2 * frame, ScreenWidth() - 2 * frame, frame);
  
  font = OpenFont(DEFAULTFONT, 16, 1);
  SetFont(font, BLACK);
  //read config file
  FILE* cfgFile = fopen(CFG_FILE, "r");
  if(cfgFile == NULL){
    Message(3, CFG_FILE, "Fehler beim Öffnen der Konfigurationsdatei.", 3000);
  }
  char label[100] = "";
  char value[100] = "";
  memset(TAZ_TARGET_DIR, 0, sizeof(TAZ_TARGET_DIR));
  memset(TAZ_USER, 0, sizeof(TAZ_USER));
  memset(TAZ_PASSWD, 0, sizeof(TAZ_PASSWD));
  while(fscanf(cfgFile, "%s = %s", &label, &value) != EOF){
    fprintf(LogFile, "label: %s, value: %s\n", label, value);
    if(strcmp(label, "username") == 0){
      strncpy(TAZ_USER, value, sizeof(TAZ_USER) - 1);
    }
    else if(strcmp(label, "passwd") == 0){
      strncpy(TAZ_PASSWD, value, sizeof(TAZ_PASSWD) - 1);
    }
    else if(strcmp(label, "directory") == 0){
      strncpy(TAZ_TARGET_DIR, value, sizeof(TAZ_TARGET_DIR) - 1);
    }
  }
  return;
}

void Button::highlight()
{
  InvertAreaBW(pos_x, pos_y, size_x, size_y);
  PartialUpdateBW(pos_x, pos_y, size_x, size_y);
  InvertAreaBW(pos_x, pos_y, size_x, size_y);
  PartialUpdateBW(pos_x, pos_y, size_x, size_y);
}

void Button::setBusy(unsigned char setBusy){
  isBusy = setBusy;
  
}

MainView::~MainView()
{
  delete statusBar;
  return;
}


void MainView::repaint()
{
  std::deque<Button>::iterator button_iterator;
  fprintf(LogFile, "MainView->repaint()\n");
  ClearScreen();		// Bildschirm löschen
  button_iterator = buttons.begin();
  while ( button_iterator != buttons.end() )
  {
    fprintf(LogFile, "MainView->repaint() loop\n");
    button_iterator->paint();
    button_iterator++;
  }
  statusBar->paint();
  fprintf(LogFile, "MainView->repaint() end\n");
  FullUpdate();
  return;
}

int MainView::hit(int x, int y)
{
  std::deque<Button>::reverse_iterator button_iterator;
  int action;
  fprintf(LogFile, "MainView->hit()\n");
  button_iterator = buttons.rbegin();
  while ( button_iterator != buttons.rend() )
  {
    action = button_iterator->hit(x,y);
    if (action > 0)
      return action;
    button_iterator++;
  }
  fprintf(LogFile, "MainView->hit() miss\n");
  return 0;
}

void MainView::highlight(int action)
{
  std::deque<Button>::iterator button_iterator;
  button_iterator = buttons.begin();
  while ( button_iterator != buttons.end() )
  {
    if (button_iterator->button_action == action)
    {
      button_iterator->highlight();;
      return;
    }
    button_iterator++;
  }
  return;
}


char* MainView::defaultNetConnection()
{
  iconfig * config;
  config = OpenConfig(NETWORKCONFIGFILE, NULL);
  return ReadString(config, "preferred", "default");
}

int MainView::NetworkConnect()
{
  if (!((QueryNetwork() & NET_WIFIREADY) || (QueryNetwork() & NET_BTREADY)))
  {
    fprintf(LogFile, "Connecting ... (%d)\n", QueryNetwork());
    return NetConnect(defaultNetConnection());
  }
  return 0;
}

int MainView::NetworkDisconnect()
{
  return NetDisconnect();
}

int MainView::GetTazToday()
{
  int pid;
  fprintf(LogFile, "MainView->GetTazToday()\n");
  if ((pid = fork()) < 0)
  {
    fprintf(LogFile, "Error forking\n");
    return -1;
  }
  if (pid == 0)
  {  /* this is the child */
    fprintf(LogFile, "fork succeded, this is the child\n");
    //char* tazURL = TAZ_URL_BASE;
    time_t currentTime = time(NULL);
    struct tm *tm = localtime(&currentTime);
    char *tazTarget = NULL;//[TAZ_TARGET_SIZE];
    asprintf(&tazTarget, "%s/taz_%d_%02d_%02d.epub", TAZ_TARGET_DIR, tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday);
    char *tazURL = NULL;
    asprintf(&tazURL, TAZ_URL_BASE, TAZ_USER, TAZ_PASSWD, tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday);
    int uid = getuid();
    setgid(getgid());
    setuid(uid);
//    fclose(LogFile);
    fprintf(LogFile, "url: %s\n", tazURL);
    fprintf(LogFile, "target: %s\n", tazTarget);
    fprintf(LogFile, "log: %s\n", WGET_LOG);
//    execlp(WGET, WGET, "-O", tazTarget, "-o", WGET_LOG, tazURL, NULL);
    execlp(WGET, WGET, "-O", tazTarget, tazURL, NULL);
    fprintf(LogFile, "Error execlp\n");
    free(tazTarget);
    free(tazURL);
    exit(1);
  }
  statusBar->setLabel("downloading taz von heute...");
  ShowHourglass();
  int status = 0;
  int retVal = wait(&status);
  fprintf(LogFile, "PID: %d, retVal: %d, status: %d\n", pid, retVal, status);
  statusBar->setLabel(STATUS_MSG);
  HideHourglass();
  if(status == 0)
    Message(3, "taz von Heute", "Download erfolgreich", 3000);
  else
    Message(3, "taz von Heute", "Fehler beim Download", 5000);
  return 0;
}

int MainView::GetTazTomorrow()
{
  int pid;
  fprintf(LogFile, "MainView->GetTazTomorrow()\n");
  if ((pid = fork()) < 0)
  {
    fprintf(LogFile, "Error forking\n");
    return -1;
  }
  if (pid == 0)
  {  /* this is the child */
    fprintf(LogFile, "fork succeded, this is the child\n");
    //char* tazURL = TAZ_URL_BASE;
    time_t currentTime = time(NULL);
    struct tm *tm = localtime(&currentTime);
    if(tm->tm_hour < 20){
      exit(2);
    }
    time_t tomorrow = currentTime + 24 * 60 * 60;
    tm = localtime(&tomorrow);
    char *tazTarget = NULL;//[TAZ_TARGET_SIZE];
    asprintf(&tazTarget, "%staz_%d_%02d_%02d.epub", TAZ_TARGET_DIR, tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday);
    char *tazURL = NULL;
    asprintf(&tazURL, TAZ_URL_BASE, TAZ_USER, TAZ_PASSWD, tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday);
    int uid = getuid();
    setgid(getgid());
    setuid(uid);
    fprintf(LogFile, "url: %s\n", tazURL);
    fprintf(LogFile, "target: %s\n", tazTarget);
    fprintf(LogFile, "log: %s\n", WGET_LOG);
    execlp(WGET, WGET, "-O", tazTarget, "-o", WGET_LOG, tazURL, NULL);
    fprintf(LogFile, "Error execlp\n");
    free(tazTarget);
    free(tazURL);
    exit(1);
  }
  statusBar->setLabel("downloading taz von Morgen...");
  ShowHourglass();
  int status = 0;
  int retVal = wait(&status);
  fprintf(LogFile, "PID: %d, retVal: %d, status: %d\n", pid, retVal, status);
  statusBar->setLabel(STATUS_MSG);
  HideHourglass();
  if(status == 0)
    Message(3, "taz von Meute", "Download erfolgreich", 3000);
  else{
    Message(3, "taz von Meute", "Fehler beim Download", 5000);
    HideHourglass();
  }
  return 0;
}

//TODO: Check Sundays
//TODO: Download any date
//TODO: Check existing files
//TODO: holidays???
//TODO: Ask for Network setup/termination
//TODO: settings dialog
