#ifndef __IPC_H__
#define __IPC_H__

/**
 * File Name  : ipc.h
 *
 * Description: The dbus-based eripc functions 
 */

/*
 * This file is part of hello_world.
 *
 * hello_world is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * hello_world is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 iRex Technologies B.V.
 * All rights reserved.
 */

#include <string.h>
#include <arpa/inet.h>

static int                dm_socket = -1;
static struct sockaddr_in dm_addr;

static int updating = 0;
//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------- 


//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------

//============================================================================
// Public Functions
//============================================================================
#ifdef __cplusplus
extern "C" {
#endif

#define DMPORT                  50555
#define DMSERVER                "127.0.0.1"

#define DM_HINT_NONE           0 
#define DM_HINT_FULL           1
#define DM_HINT_SPLASH         2
#define DM_HINT_CURSOR         3
#define DM_HINT_PARTIAL        4
#define DM_HINT_KEY            5
#define DM_HINT_UNLOCK         6
#define DM_HINT_LOCK           7

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_set_services
 *
 * @brief  Setup IPC connection and register API functions
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_set_services ( void );

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_unset_services
 *
 * @brief  Unregister API functions
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_unset_services ( void );


/**---------------------------------------------------------------------------
 *
 * Name :  ipc_sys_startup_complete
 *
 * @brief  Report "application started" to sysd
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_sys_startup_complete ( int my_xid );

void ipc_menu_add_menu( const char *name,
                        const char *group1,
                        const char *group2,
                        const char *group3 );
void ipc_menu_show_menu( const char *name );

void dr_menu_init(void);

void display_update(int waveform);

#ifdef __cplusplus
}
#endif


#endif /* __IPC_H__ */
