/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.OutStream;
import rfb.ConnParams;
import rfb.Decoder;
import rfb.PixelFormat;

public abstract class CMsgWriter {
    ConnParams cp;
    OutStream os;

    public abstract void writeClientInit(boolean var1);

    public void writeSetPixelFormat(PixelFormat pf) {
        this.startMsg(0);
        this.os.pad(3);
        pf.write(this.os);
        this.endMsg();
    }

    public void writeSetEncodings(int nEncodings, int[] encodings) {
        this.startMsg(2);
        this.os.skip(1);
        this.os.writeU16(nEncodings);
        int i = 0;
        while (i < nEncodings) {
            this.os.writeU32(encodings[i]);
            ++i;
        }
        this.endMsg();
    }

    public void writeSetEncodings(int preferredEncoding, boolean useCopyRect) {
        int nEncodings = 0;
        int[] encodings = new int[257];
        if (this.cp.supportsLocalCursor) {
            encodings[nEncodings++] = -239;
        }
        if (this.cp.supportsDesktopResize) {
            encodings[nEncodings++] = -223;
        }
        if (Decoder.supported(preferredEncoding)) {
            encodings[nEncodings++] = preferredEncoding;
        }
        if (useCopyRect) {
            encodings[nEncodings++] = 1;
        }
        int i = 255;
        while (i >= 0) {
            if (i != preferredEncoding && Decoder.supported(i)) {
                encodings[nEncodings++] = i;
            }
            --i;
        }
        this.writeSetEncodings(nEncodings, encodings);
    }

    public void writeFramebufferUpdateRequest(int x, int y, int w, int h, boolean incremental) {
        this.startMsg(3);
        this.os.writeU8(incremental ? 1 : 0);
        this.os.writeU16(x);
        this.os.writeU16(y);
        this.os.writeU16(w);
        this.os.writeU16(h);
        this.endMsg();
    }

    public void writeKeyEvent(int key, boolean down) {
        this.startMsg(4);
        this.os.writeU8(down ? 1 : 0);
        this.os.pad(2);
        this.os.writeU32(key);
        this.endMsg();
    }

    public void writePointerEvent(int x, int y, int buttonMask) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.cp.width) {
            x = this.cp.width - 1;
        }
        if (y >= this.cp.height) {
            y = this.cp.height - 1;
        }
        this.startMsg(5);
        this.os.writeU8(buttonMask);
        this.os.writeU16(x);
        this.os.writeU16(y);
        this.endMsg();
    }

    public void writeClientCutText(String str) {
        this.startMsg(6);
        this.os.pad(3);
        this.os.writeString(str);
        this.endMsg();
    }

    public abstract void startMsg(int var1);

    public abstract void endMsg();

    public void setOutStream(OutStream os_) {
        this.os = os_;
    }

    ConnParams getConnParams() {
        return this.cp;
    }

    OutStream getOutStream() {
        return this.os;
    }

    protected CMsgWriter(ConnParams cp_, OutStream os_) {
        this.cp = cp_;
        this.os = os_;
    }
}

