#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, Grant Drake <grant.drake@gmail.com>'
__docformat__ = 'restructuredtext en'

import copy
from PyQt4.Qt import QWidget, QVBoxLayout, QLabel, QLineEdit, \
                     QGroupBox, QFormLayout
from calibre.utils.config import JSONConfig
from calibre_plugins.find_duplicates.common_utils import get_library_uuid

STORE_OPTIONS = 'options'
KEY_SHORTCUT_FIND_DUPLICATES = 'shortcutFindDuplicates'
KEY_SHORTCUT_NEXT = 'shortcutNext'
KEY_SHORTCUT_PREVIOUS = 'shortcutPrevious'
KEY_SHORTCUT_GROUP_NOT_DUPLICATE = 'shortcutGroupNotDuplicate'
KEY_SHORTCUT_CLEAR_RESULTS = 'shortcutClearResults'

DEFAULT_OPTIONS_VALUES = {
    KEY_SHORTCUT_FIND_DUPLICATES:       '',
    KEY_SHORTCUT_NEXT:                  'Ctrl+\\',
    KEY_SHORTCUT_PREVIOUS:              'Ctrl+Shift+\\',
    KEY_SHORTCUT_GROUP_NOT_DUPLICATE:   '',
    KEY_SHORTCUT_CLEAR_RESULTS:         ''
}

KEY_TITLE_MATCH = 'titleMatch'
KEY_AUTHOR_MATCH = 'authorMatch'
KEY_SHOW_ALL_GROUPS = 'showAllGroups'
KEY_SORT_GROUPS_TITLE = 'sortGroupsByTitle'

STORE_LIBRARIES = 'libraries'
KEY_BOOK_EXEMPTIONS = 'bookNotDuplicates'
KEY_AUTHOR_EXEMPTIONS = 'authorNotDuplicates'
DEFAULT_LIBRARIES_VALUES = {}
DEFAULT_LIBRARY_VALUES = {
                            KEY_BOOK_EXEMPTIONS: {},
                            KEY_AUTHOR_EXEMPTIONS: {}
                         }

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/Find Duplicates')

# TODO: Remove this code, playing nice
if 'lastAlgorithm' in plugin_prefs:
    del plugin_prefs['lastAlgorithm']

# Set defaults
plugin_prefs.defaults[STORE_OPTIONS] = DEFAULT_OPTIONS_VALUES
plugin_prefs.defaults[STORE_LIBRARIES] = DEFAULT_LIBRARIES_VALUES

def get_library_config(db):
    library_id = get_library_uuid(db)
    libraries = plugin_prefs[STORE_LIBRARIES]
    library = libraries.get(library_id, copy.deepcopy(DEFAULT_LIBRARY_VALUES))
    return library

def get_exemption_maps(db):
    c = get_library_config(db)

    book_exemptions = get_library_config(db)[KEY_BOOK_EXEMPTIONS]
    # Convert into a dictionary[int] of set
    book_exemptions_map = dict()
    for book_id, val in book_exemptions.iteritems():
        book_exemptions_map[int(book_id)] = set(val)

    author_exemptions = get_library_config(db).get(KEY_AUTHOR_EXEMPTIONS, {})
    # Convert into a dictionary[string] of set
    author_exemptions_map = dict()
    for author, val in author_exemptions.iteritems():
        author_exemptions_map[author] = set(val)

    return book_exemptions_map, author_exemptions_map

def set_exemption_map(db, config_key, exemptions_map):
    library_id = get_library_uuid(db)
    libraries = plugin_prefs[STORE_LIBRARIES]
    library = get_library_config(db)

    # We need to persist our dictionary of sets as a dictionary of lists
    exemptions = dict()
    for key, value in exemptions_map.iteritems():
        exemptions[key] = list(value)
    library[config_key] = exemptions

    libraries[library_id] = library
    plugin_prefs[STORE_LIBRARIES] = libraries

class ConfigWidget(QWidget):

    def __init__(self):
        QWidget.__init__(self)
        layout = QVBoxLayout(self)
        self.setLayout(layout)

        group_box = QGroupBox('Keyboard shortcuts:', self)
        layout.addWidget(group_box)
        group_box_layout = QFormLayout()
        group_box.setLayout(group_box_layout)

        c = plugin_prefs[STORE_OPTIONS]
        for key, text in [(KEY_SHORTCUT_FIND_DUPLICATES, '&Find duplicates'),
                          (KEY_SHORTCUT_NEXT, '&Next result'),
                          (KEY_SHORTCUT_PREVIOUS, '&Previous result'),
                          (KEY_SHORTCUT_GROUP_NOT_DUPLICATE, '&Mark group as exempt'),
                          (KEY_SHORTCUT_CLEAR_RESULTS, '&Clear duplicate results')
                          ]:
            label = QLabel(text+':', self)
            lineEdit = QLineEdit(c.get(key, ''), self)
            setattr(self, '_'+key, lineEdit)
            label.setBuddy(lineEdit)
            group_box_layout.addRow(label, lineEdit)

    def save_settings(self):
        new_prefs = {}
        for key in (KEY_SHORTCUT_FIND_DUPLICATES, KEY_SHORTCUT_NEXT, KEY_SHORTCUT_PREVIOUS,
                    KEY_SHORTCUT_GROUP_NOT_DUPLICATE, KEY_SHORTCUT_CLEAR_RESULTS):
            new_prefs[key] = unicode(getattr(self, '_'+key).text()).strip()

        plugin_prefs[STORE_OPTIONS] = new_prefs
