#!/bin/sh

# This program will backup your kindle's original
# collection files and rebuild a new collection based
# on the structure of the documents directory. 


BASE=/mnt/us
#BASE=/Volumes/Kindle

DOCDIR=${BASE}/documents
SYSDIR=${BASE}/system
BINDIR=/mnt/us/collgen/



find $DOCDIR -type d -maxdepth 1  -exec basename {} \; | grep -v 'documents' > /tmp/__bbbbb__collgen
find $DOCDIR -type f -name "*.pdf" >/tmp/__ccccc__collgen
find $DOCDIR -type f -name "*.mobi" >>/tmp/__ccccc__collgen
find $DOCDIR -type f -name "*.azw" >>/tmp/__ccccc__collgen
find $DOCDIR -type f -name "*.prc" >>/tmp/__ccccc__collgen
find $DOCDIR -type f -name "*.txt" >>/tmp/__ccccc__collgen

> $BINDIR/c.json
echo -n "{" >> $BINDIR/c.json

t=1
while read line
do
    echo $line
    if [ "$t" == "0" ];then 
        echo -n "," >> $BINDIR/c.json 
    fi

    echo -n "\"$line@zh-CN\":{\"items\":[" >> $BINDIR/c.json
        
    f=1
    cat /tmp/__ccccc__collgen | grep "/$line/" | while read bline
    do
        if [ "$f" == "0" ];then 
            echo -n "," >> $BINDIR/c.json 
        fi
        f=0;
        ASIN=""
        exten=`echo "$bline" | awk -F . '{print $NF}'`


        if [ "$exten" == "azw" ] || [ "$exten" == "prc" ];then 
            ASIN=`cat "$bline" | $BINDIR/ext`
        fi
        
        if [ "$exten" == "mobi" ];then
            ASIN=`cat "$bline" | $BINDIR/ext`
        fi
        
        if [ "$ASIN" == "" ];then
	    SIGN=`echo "$bline" | $BINDIR/shatest`
            echo "$bline   $SIGN";
            echo -n "\"*$SIGN\"" >> $BINDIR/c.json
        else
            echo "$bline   $ASIN";
            echo -n "\"#$ASIN^EBOK\"" >> $BINDIR/c.json
        fi
    done    
    echo -n "],\"lastAccess\":0}" >>$BINDIR/c.json                
done < /tmp/__bbbbb__collgen

echo  "}" >> $BINDIR/c.json




rm /tmp/__bbbbb__collgen /tmp/__ccccc__collgen

if [ -s $SYSDIR/collections.json ];then
    cp $SYSDIR/collections.json $SYSDIR/collections.json.bak
fi

cp $BINDIR/c.json $SYSDIR/collections.json


/etc/init.d/framework restart


exit 0




