/**
 * Provide gestures for ipdf
 *
 * @author Rincewind@irexforums
 */

#ifndef __GESTURES_H__
#define __GESTURES_H__

#include <map>

// The size of the box around the pen for gestures
#define BOUNDING_BOX_SIZE 10

enum Direction {
    DIRECTION_NONE = 0,
    DIRECTION_UP,
    DIRECTION_DOWN,
    DIRECTION_LEFT,
    DIRECTION_RIGHT
};

enum GestureFunction {
    FUNC_UNDEFINED,
    FUNC_INCREASE_PEN,
    FUNC_DECREASE_PEN,
    FUNC_DARKER_COLOR,
    FUNC_LIGHTER_COLOR,
    FUNC_ZOOM_IN,
    FUNC_ZOOM_OUT,
    FUNC_REFRESH_DISPLAY
};


#define MAX_GESTURE_LENGTH 6

/**
 * Class to hold gesture informatino
 */
class Gesture {

    private:

    Direction directions[MAX_GESTURE_LENGTH];
    int idx;

    public:
    Gesture() {
	clear();
    }
    
    void clear() {
	memset(directions, 0, sizeof(directions));
	idx = 0;
    }

    void addDirection(Direction dir) {
	directions[idx] = dir;
	idx++;
    }

    int numDirections() {
	return idx;
    }

    Gesture &operator=(const Direction dirs[]) {
	
	Direction *dir;
	dir = (Direction*) dirs;
	while (dir) {
	    directions[idx] = *dir;
	    idx++;
	    dir++;
	    if (idx >= MAX_GESTURE_LENGTH)
		break;
	}
	
	return *this;
    }

    inline bool operator==(const Gesture &gst) const {
	return (memcmp(&directions, &gst.directions, sizeof(directions)) == 0);
    }

    inline bool operator<(const Gesture &gst) const {
	return (memcmp(&directions, &gst.directions, sizeof(directions)) < 0);
    }

    inline bool operator>(const Gesture &gst) const {
	return (memcmp(&directions, &gst.directions, sizeof(directions)) > 0);
    }
};


typedef std::map<Gesture, GestureFunction> GestureMap;


#endif
