var cardx;
var cardy;
var step = 20;
var smallstep;
var zindex;
var starttop;
var undostack;
var undo;
var ordercount;
var lastorder;
var deletecounter;
var aceendnumber;
var colours;
var randgame = Math.random();
var oldgame;

$(function () {
  // set cards
  setCards(2, randgame, false);

  $('#showoptions').click(function () {
    $('#showoptions').hide();
    $('#hideoptions').show();
    $('#options').show();
    return false;
  });

  $('#hideoptions').click(function () {
    hideOptions();
    return false;
  });

  $('#doUndo').click(function () {
    doUndo();
    return false;
  });

  $('#restart').click(function () {
    setCards(colours, randgame, true);
    hideOptions();
    return false;
  });

  $('#new1').click(function () {
    colours = 1;
    randgame = Math.random();
    setCards(colours, randgame, false);
    hideOptions();
    return false;
  });

  $('#new2').click(function () {
    colours = 2;
    randgame = Math.random();
    setCards(colours, randgame, false);
    hideOptions();
    return false;
  });

  $('#new4').click(function () {
    colours = 4;
    randgame = Math.random();
    setCards(colours, randgame, false);
    hideOptions();
    return false;
  });
});

function hideOptions() {
  $('#showoptions').show();
  $('#hideoptions').hide();
  $('#options').hide();
}

function setCards(howhard, randseed, restart) {
  cardx = 55;
  cardy = 107;
  smallstep = 4;
  zindex = 101;
  starttop = 0;
  undostack = Array();
  undo = Array();
  ordercount = 0;
  lastorder;
  deletecounter = 0;
  aceendnumber = 0;
  colours = howhard;

  if (restart) shuffled = oldgame;
  else {
    deck = getDeck(howhard);
    shuffled = shuffle(deck);
    oldgame = shuffled;
  }

  // clear the deck
  $('.deck').children().remove();

  // place shuffled cards on the deck:
  var a = 0;

  // 1) 10 card decks
  var theend = 5;
  for (j = 0; j < 10; j++) {
    if (j == 4) theend = 4;

    // add card0
    var thecard = placeCard(j * 60, -1, 'bottom', 'bottom' + j, j);
    $('#' + thecard).unbind();
    setCardAsBottom(thecard);

    for (i = 0; i < 6; i++) {
      if (i <= theend) {
        var left = j * 60;
        var top = starttop + i * 6;
        if (i == theend) placeHidden = 'no';
        else placeHidden = 'yes';
        var thecard = placeCard(left, top, placeHidden, shuffled[a], j);
        if (i == theend) {
          setCardAsMovable(thecard);
        }
        a++;
      }
    }
  }

  // 5 hidden
  for (j = 0; j < 5; j++) {
    for (i = 0; i < 10; i++) {
      var left = 600 - 60 - 8 * j;
      var top = 700 - 110;
      var thecard = placeCard(left, top, 'yes', shuffled[a], 30 + j);
      if (j == 4) {
        setCardAsNewThread(thecard);
      }
      a++;
    }
  }
}

function isCardNeibourgh(source, destination, mustbethesamecolour) {
  var thesource = source.split('_');
  var thedestination = destination.split('_');

  // how high are the cards
  var ps = thesource[2];
  var pd = thedestination[2];

  var cols = thesource[1];
  var cold = thedestination[1];
  if (mustbethesamecolour && cols != cold) return false;

  ps++;
  pd++;
  if (ps == 13) // ace
  ps = 0;
  if (pd == 13) // ace
  pd = 0;

  if (ps + 1 == pd) return true;
  return false;
}

function isEmptyBottom(thecard) {
  var subdeck = getCardSubDeck(thecard);
  if ($('.' + subdeck).length == 1) return true;
}

function setCardAsBottom(thecard) {
  $('#' + thecard).click(function () {
    if (isEmptyBottom(thecard)) {
      // check if sth is selected
      var source = $('.selected').attr('id');
      var destination = $(this).attr('id');
      $('.deck').children().removeClass('selected');
      if (source && source != destination) {
        moveCardAbove(source, destination, 'bottom');
      }
      $('.deck').children().removeClass('selected');
    }
    return false;
  });
}

function setCardAsMovable(thecard) {
  $('#' + thecard).unbind();
  $('#' + thecard).click(function () {
    // check if sth is selected
    var source = $('.selected').attr('id');
    var destination = $(this).attr('id');
    $('.deck').children().removeClass('selected');
    var doSelect = false;
    if (source && source != destination) {
      // if so - try moving it on this card
      // 1) source card must be one point smaller
      if (isCardNeibourgh(source, destination, false)) {
        if (!moveCardAbove(source, destination, '')) {
          doSelect = true;
        }
      } else {
        doSelect = true;
      }

      // 2) over destination card must not be any card
      // 3) over source cards must be of the same colour
    }
    // if not - select this card
    else {
      // children must be the same colour and every next one lower
      doSelect = true;
    }

    if (doSelect) {
      if (isInOrder(destination, true)) {
        $(this).addClass('selected');
      }
    }
    return false;
  });
}

function addToUndo(thecard, hidden) {
  undot = Array();
  undot['id'] = thecard;
  undot['class'] = $('#' + thecard).attr('class');
  undot['top'] = $('#' + thecard).css('top');
  undot['left'] = $('#' + thecard).css('left');
  undot['bpos'] = $('#' + thecard).css('background-position');
  undot['zindex'] = $('#' + thecard).css('z-index');
  undot['hidden'] = hidden == 'hidden';
  undo.push(undot);
}

function unhiddenCard(thecard) {
  addToUndo(thecard, 'hidden');
  $('#' + thecard).removeClass('hidden');
  $('#' + thecard).addClass('nothidden');
  var carddata = thecard.split('_');
  if (thecard.substr(0, 6) != 'bottom') {
    $('#' + thecard).css({
      backgroundPosition: '-' + carddata[3] + 'px -' + carddata[4] + 'px'
    });
    setCardAsMovable(thecard);
  }
}

function getCardSubDeck(source) {
  var classes = $('#' + source).attr('class').split(' ');
  var sourcedeck = '';
  for (i in classes) {
    if (classes[i].substr(0, 7) == 'subdeck') sourcedeck = classes[i];
  }
  return sourcedeck;
}

function isTopCard(test) {
  var subdeck = getCardSubDeck(test);
  var top = parseInt($('#' + test).css('top'));
  var isTop = true;
  $('.' + subdeck).each(function () {
    if (parseInt($(this).css('top')) > top) isTop = false;
  });
  return isTop;
}

function isInOrder(test, firsttest) {
  if (firsttest) ordercount = 0;

  if (isTopCard(test)) {
    ordercount++;
    lastorder = test;
    return true;
  }
  var data1 = test.split('_');
  var top = parseInt($('#' + test).css('top'));
  var subdeck = getCardSubDeck(test);
  var isOk = true;
  $('.nothidden.' + subdeck).each(function () {
    if (parseInt($(this).css('top')) == top + step) // next card
    {
/*var data2 = $(this).attr('id').split('_');
			if(data1[1]==data2[1]) // the same colour - text next
				isOk = isInOrder($(this).attr('id'));
			else
				isOk = false;*/
      isOk = isCardNeibourgh($(this).attr('id'), test, true);
      if (isOk) {
        isOk = isInOrder($(this).attr('id'), false);
      }
    }
  });
  if (isOk) {
    ordercount++;
    lastorder = test;
  }
  return isOk;
}

function doUndo() {
  undo = undostack.pop();
  if (typeof undo != 'undefined') {
    while (undot = undo.pop()) {
      var id = undot['id'];
      $('#' + id).attr('class', undot['class']);
      $('#' + id).css('top', undot['top']);
      $('#' + id).css('left', undot['left']);
      $('#' + id).css('background-position', undot['bpos']);
      $('#' + id).css('z-index', undot['zindex']);
      if (undot['hidden']) {
        $('#' + id).unbind();
      }
    }
  }
  undo = Array();
  $('.selected').removeClass('selected');
}

function moveCardAbove(source, destination, typeofdest) {
  // you can't move card from the same deck!
  var sourcedeck = getCardSubDeck(source);
  var destinationdeck = getCardSubDeck(destination);
  if (sourcedeck == destinationdeck) return false;

  // you can't move card on anything other than top card
  if (!isTopCard(destination)) return false;

  // remember for undo
  addToUndo(source, '');
  addToUndo(destination, '');

  var oldleft = $('#' + source).css('left');
  var oldtop = $('#' + source).css('top');
  $('#' + source).css('left', $('#' + destination).css('left')); // move to the column of destination
  //$(source).css('top', ); // move to the column of destination
  var top = parseInt($('#' + destination).css('top'));
  var tops = (top + step) + 'px';
  if (typeofdest == 'bottom') tops = (top + 1) + 'px';
  $('#' + source).css('top', tops);
  $('#' + source).css('z-index', zindex);
  zindex++;
  $('#' + source).removeClass(sourcedeck);
  $('#' + source).addClass(destinationdeck);

  // if there is card above this card -> move it too
  $('.nothidden.' + sourcedeck).each(function () {
    if (
    $(this).attr('id') != source && $(this).css('left') == oldleft && parseInt($(this).css('top')) == (parseInt(oldtop) + step)) {
      moveCardAbove($(this).attr('id'), source, 'noundo');
    }
  });

  // if there is card below that is hidden - unhidden it
  $('.hidden.' + sourcedeck).each(function () {
    if (isTopCard($(this).attr('id'))) {
      unhiddenCard($(this).attr('id'));
    }
  });

  if (typeofdest != 'noundo') {
    undostack.push(undo);
    undo = Array();
    checkEnding();
  }

  return true;
}

function checkEnding() {
  // check if there is enough cards for K to A.
  for (var ii = 0; ii < 10; ii++) {
    $('.king.nothidden.subdeck' + ii).each(function () {
      if (isInOrder($(this).attr('id'), true)) {
        if (ordercount == 13) {
          deleteEnding();
          return;
        }
      }
    });
  }
  // if so - remove it, show additional A in the corner
}

function deleteToTheEnd() {
  var subdeck = getCardSubDeck(lastorder);
  var top = parseInt($('#' + lastorder).css('top'));
  $('#' + lastorder).remove();
  $('.nothidden.' + subdeck).each(function () {
    if (parseInt($(this).css('top')) == top + step) // next card
    {
      lastorder = $(this).attr('id');
      deleteToTheEnd();
    }
  });
}

function deleteEnding() {
  // get next
  var data = $('#' + lastorder).attr('id').split('_');
  deleteToTheEnd();
  $('.deck').append('<div class="card" style="opacity:.5" id="aceend' + aceendnumber + '"></div>');

  var aceend = $('#aceend' + aceendnumber);
  aceend.css('left', (5 + aceendnumber * 60) + 'px');
  aceend.css('top', (500 - 107 - 10) + 'px');

  aceend.css({
    backgroundPosition: '-662px -' + 107 * data[1] + 'px'
  });

  aceendnumber++;
  if (aceendnumber == 8) {
    // TO KONIEC GRY
    alert('Congratulations!');
    randgame = Math.random();
    setCards(colours, randgame, false);
    return;
  }
  for (var ii = 0; ii < 10; ii++) {
    $('.hidden.subdeck' + ii).each(function () {
      if (isTopCard($(this).attr('id'))) {
        unhiddenCard($(this).attr('id'));
      }
    });
  }
  undo = Array();
  undostack = Array();
  checkEnding();
}

function setCardAsNewThread(thecard) {
  var i = 0;
  $('#' + thecard).click(function () {

    // only if there is no empty space
    for (j = 0; j < 10; j++) {
      if (isEmptyBottom($('#bottom' + j).attr('id'))) {
        alert("There must be no empty spaces left.");
        return false;
      }
    }

    undo = Array();
    undostack = Array();
    var sourcedeck = getCardSubDeck(thecard);
    $('.' + sourcedeck).each(function () {
      var theid = $(this).attr('id');

      var maxtop = 0;
      $('.subdeck' + i).each(function () {
        var top = parseInt($(this).css('top'));
        if (top > maxtop) maxtop = top;
      });
      if (maxtop >= starttop) maxtop += step;
      else maxtop = starttop;

      //placeCard(i*60, maxtop+step, 'no', theid, i);
      $('#' + theid).css('top', maxtop + 'px');
      $('#' + theid).css('left', i * 60 + 'px');
      $('#' + theid).css('z-index', zindex);
      zindex++;
      $('#' + theid).addClass('subdeck' + i);
      $('#' + theid).removeClass(sourcedeck);
      unhiddenCard(theid);
      i++;
      if (i == 10) // set as thread next group of cards
      {
        var thisdeck = parseInt(sourcedeck.substr(7));
        if (thisdeck != 30) {
          $('.subdeck' + (thisdeck - 1)).each(function () {
            var thecard = $(this).attr('id');
            setCardAsNewThread(thecard);
          });
        }
      }
    });
    undo = Array();
    undostack = Array();
    $('.deck').children().removeClass('selected');
    return false;
  });
}

function placeCard(left, top, hidden, thecard, subdeck) {
  var carddata = thecard.split('_');
  hiddenstyle = ' hidden subdeck' + subdeck;
  if (hidden == 'no') {
    var bx = -carddata[3];
    var by = -carddata[4];
    hiddenstyle = ' nothidden subdeck' + subdeck;
  } else if (hidden == 'bottom') {
    var bx = -717;
    var by = -324;
    hiddenstyle = ' hidden subdeck' + subdeck;
  } else {
    var bx = -717;
    var by = -217;
  }
  if (carddata[2] == 11) // it's a KING
  {
    hiddenstyle += ' king';
  }
  var card = '<div id="' + thecard + '" class="card' + hiddenstyle + '" style="background-position: ' + bx + 'px ' + by + 'px; left: ' + left + 'px; top: ' + top + 'px;"></div>';
  $('.deck').append(card);
  return thecard;
}

function getDeck(howhard) {
  var deck = Array();
  var a = 0;
  for (d = 0; d < 2; d++) {
    for (i = 0; i < 4; i++) {
      for (j = 0; j < 13; j++) {
        cardx = Math.floor(j * 55.1);
        colourcode = (i % howhard);
        switch (colourcode) {
        case 0:
          colourcode = 0;
          break;
        case 1:
          colourcode = 2;
          break;
        case 2:
          colourcode = 1;
          break;
        case 3:
          colourcode = 3;
          break;
        }
        cardy = colourcode * 107 + 1;
        deck[a] = (d * 14 * 4 + 14 * i + j) + "_" + colourcode + "_" + j + "_" + cardx + "_" + cardy;
        a++;
      }
    }
  }
  return deck;
}

//+ Jonas Raoni Soares Silva
//@ http://jsfromhell.com/array/shuffle [v1.0]
shuffle = function (o) { //v1.0
  for (var j, x, i = o.length; i; j = parseInt(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
  return o;
};