#!/bin/sh

_FUNCTIONS=/etc/rc.d/functions
[ -e ${_FUNCTIONS} ] && . ${_FUNCTIONS}

_PATHS=/etc/sysconfig/paths
[ -e $_PATHS ] && . $_PATHS

BLOCKS=4096
DEVZERO=/dev/zero

VARPART=`df | sed '/\/var\/local/!d; s/\(\S*\)\s*.*local.*/\1/g'`
VARSIZE=`df | sed '/\/var\/local/!d; s/\S*\s*\(\S*\).*local.*/\1/g'`
if [ $VARSIZE -lt $BLOCKS ]; then 
	VARBLOCK=$VARSIZE
else
	VARBLOCK=$BLOCKS
fi

msg "resetting $VARPART to prevent conflicts" I
dd if=$DEVZERO of=$VARPART count=$VARBLOCK
_RES1=$?

if [ ${_RES1} -eq 0 ]; then
	msg "reset completed successfully" I
else
	msg "reset failed: $VARPART=${_RES1}" E
fi

if [ -f /mnt/us/tts-files.tar ]; then
	msg "found tts files, extracting" I
	tar -C /mnt/us -xf /mnt/us/tts-files.tar
fi

msg "rebooting to prevent conflicts" I

mntroot_rw
rm -f /sbin/setup.sh
sync
/sbin/shutdown -r now
