#!/bin/sh
## Something a bit like a windows short-cut for iliad PDF containers.

####################################################
##
## User needs to define where the USB mounts to on the PC
##
####################################################

## This is where your usb disk mounts on your PC
PCMOUNTDIR="/media/UDISK\ 2.0"




####################################################
##
## User does not need to change anything below here.
##
####################################################

## This is where the device mounts on the iliad. 
iliadMOUNTDIR="/mnt/usb"

## Get the path of the selected PDF container.
## First see if the parameter has been sent on the command line, i.e. this is not being
## run from gnome.
if [ -d "$1" ]
then
  SOURCE="$(pwd)/$1"
else
    ## Assume that we are using the gnome file manager
    SOURCE=$(echo -e "$NAUTILUS_SCRIPT_SELECTED_FILE_PATHS" | awk 'BEGIN {
FS = "\n" } { printf "\"%s\" ", $1 }' | sed -e 's|^"\(.*\)" ""|\1|')
fi


## Remove any trailing space from the directory name
SOURCE=$(echo "${SOURCE}" | sed -e 's/ *//')

## Create a name for the new container. It can be anything that 
## is unique. It will not appear in the contentlister.
NEWDIR=${SOURCE}-shortcut

## Create the full path to the original container as it appears 
## when mounted on the iliad.
ABSSOURCE=$(echo "$SOURCE" | sed -e "s|$PCMOUNTDIR|$iliadMOUNTDIR|")

# ## Create the new container directory and new manifest.xml
mkdir "$NEWDIR"
sed -e "
# Hard code the path to the original file
s|<startpage>\(.*\)</startpage>|<startpage>$ABSSOURCE/\1</startpage>|
# Edit the title to show that it is a link
s|<Title>\(.*\)</Title>|<Title>Shortcut to \1</Title>|
# Remove any existing references to an image
s|<image>\(.*\)</image>||
s|<image/>||
# Add an image to show that it is a link.
s|<y-metadata>|<y-metadata><image>image.png</image>|
" "$SOURCE/manifest.xml" > "$NEWDIR/manifest.xml"


## Image to display in contentlister
cp $HOME/.gnome2/nautilus-scripts/iLiad/image.png "$NEWDIR/image.png"


