#!/bin/sh
# yokos
# a little shell script which shows the output of the xpdf command tools
# pdftotext, pdfimages, pdffonts, pdfinfo & pdftops
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir
mkdir output
#echo "$scriptdir" > scriptdir.txt
cd ..
cd bin
# Creating txt output, -layout for support of columns
./pdftotext -f 1 -l 3 -layout ${scriptdir}/sample1.pdf ${scriptdir}/output/pdftotext_sample1.txt
./pdftotext -f 1 -l 4 -layout ${scriptdir}/sample2.pdf ${scriptdir}/output/pdftotext_sample2.txt
# Extracting included images of pdf file; -j for jpg 
./pdfimages -f 1 -l 1 -j ${scriptdir}/sample1.pdf ${scriptdir}/output/
# font analyzer
./pdffonts -f 1 -l 3 ${scriptdir}/sample1.pdf > ${scriptdir}/output/pdffonts_sample1.txt
# document information extractor 
./pdfinfo -f 1 -l 3  -box -meta ${scriptdir}/sample1.pdf > ${scriptdir}/output/pdfinfo_sample1.txt
# pdf to ps converter
./pdftops -f 1 -l 1 -level2 ${scriptdir}/sample1.pdf ${scriptdir}/output/pdftops_sample1.ps
